using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

namespace gov.va.med.vbecs.GUI.controls
{
	/// <summary>
	/// Summary description for DataGridUnitPhenotype.
	/// </summary>
	public class DataGridUnitPhenotype : System.Windows.Forms.Panel
	{
		private string _errorMessage1 = Common.StrRes.Tooltips.Common.InterpretationNotMatch().ResString;
		private string _errorMessage2 = Common.StrRes.Tooltips.Common.InvalidTestResults().ResString;
		private string _errorMessage3 = Common.StrRes.Tooltips.UC098.ISOnlyResults().ResString;
		//
		private System.EventHandler onCurrentCellChanged;
		//
		private string _validEntries;
		private Common.ReactivityPhase _testPhases;
		private DateTime _testingDate;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbLotNumber;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbReagentType;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbControlComment;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbComment;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbWeakDComment;
		private System.Data.DataTable _dataTablePhenotype;
		private DataRow _drPhenotype;
		private System.Data.DataTable _dataTableControl;
		private DataRow _drControl;
		private System.Data.DataTable _dataTableWeakD;
		private DataRow _drWeakD;
		private DataTable _dtPosReagents;
		private DataTable _dtNegReagents;
		private DataTable _dtReagentTypes;
		private int _posReagentTypeID;
		private int _negReagentTypeID;
		private DataTable _dtComments;
		private System.Windows.Forms.DataGridTableStyle _dgPhenotypeTableStyle;
		private System.Windows.Forms.DataGridTableStyle _dgControlTableStyle;
		private System.Windows.Forms.DataGridTableStyle _dgWeakDTableStyle;
		private System.Windows.Forms.DataGridTextBoxColumn _dcTextBox;
		private System.Windows.Forms.DataGridBoolColumn _dcCheckBox;
		private controls.DataGridKeyTrapTextBoxColumn _dcTextKeyTrapCol;
		private gov.va.med.vbecs.GUI.controls.PhenotypeControlDataGrid dgControl;
		private gov.va.med.vbecs.GUI.controls.PhenotypeDataGrid dgPhenotype;
		private System.Windows.Forms.GroupBox grpLot;
		private System.Windows.Forms.TextBox txtExpires;
		private System.Windows.Forms.Label lblExpires;
		private System.Windows.Forms.TextBox txtManufacturer;
		private System.Windows.Forms.Label lblManufacturer;
		private System.Windows.Forms.TextBox txtLotNumber;
		private System.Windows.Forms.Label lblLotNumber;
		private System.Windows.Forms.Button btnInvalidateResults;
		private gov.va.med.vbecs.GUI.controls.WeakDDataGrid dgWeakD;
		private System.Windows.Forms.ToolTip ttToolTip;
		private System.ComponentModel.IContainer components;

		private System.Guid _parentFormGuid = System.Guid.Empty;

		//CR 2792
		private bool _keyPressEventHandledPheno;
		private bool _keyPressEventHandledWeakD;

		//CR 2864
		private bool _userSwitchingTabs = false;

		/// <summary>
		/// DataGridUnitPhenotype
		/// </summary>
		public DataGridUnitPhenotype()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();
			//
			InitializeControlGrid();
			InitializePhenotypeGrid();
			InitializeWeakDGrid();
		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Locking

		/// <summary>
		/// Event needed for locking - signals to the containing form that the user is "doin' stuff"
		/// </summary>
		public event EventHandler UserActivity;

		/// <summary>
		/// Event needed for locking - signals to the containing form that the user is "doin' stuff"
		/// </summary>
		protected void OnUserActivity()
		{
			if (this.UserActivity != null)
				this.UserActivity(this, System.EventArgs.Empty);
		}

		#endregion

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DataGridUnitPhenotype));
			this.dgControl = new gov.va.med.vbecs.GUI.controls.PhenotypeControlDataGrid();
			this.dgPhenotype = new gov.va.med.vbecs.GUI.controls.PhenotypeDataGrid();
			this.cmbLotNumber = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.cmbReagentType = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.cmbControlComment = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.cmbComment = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.cmbWeakDComment = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.grpLot = new System.Windows.Forms.GroupBox();
			this.txtExpires = new System.Windows.Forms.TextBox();
			this.lblExpires = new System.Windows.Forms.Label();
			this.txtManufacturer = new System.Windows.Forms.TextBox();
			this.lblManufacturer = new System.Windows.Forms.Label();
			this.txtLotNumber = new System.Windows.Forms.TextBox();
			this.lblLotNumber = new System.Windows.Forms.Label();
			this.btnInvalidateResults = new System.Windows.Forms.Button();
			this.dgWeakD = new gov.va.med.vbecs.GUI.controls.WeakDDataGrid();
			this.ttToolTip = new System.Windows.Forms.ToolTip(this.components);
			((System.ComponentModel.ISupportInitialize)(this.dgControl)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.dgPhenotype)).BeginInit();
			this.grpLot.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.dgWeakD)).BeginInit();
			this.SuspendLayout();
			// 
			// dgControl
			// 
			this.dgControl.AllowSorting = false;
			this.dgControl.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dgControl.CaptionFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgControl.CaptionText = "Unit Antigen Typing";
			this.dgControl.CaptionVisible = false;
			this.dgControl.DataMember = string.Empty;
			this.dgControl.Direction = gov.va.med.vbecs.GUI.controls.GridDirection.Up;
			this.dgControl.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgControl.HeaderFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgControl.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.dgControl.Location = new System.Drawing.Point(0, 0);
			this.dgControl.Name = "dgControl";
			this.dgControl.PhenotypeDataGrid = null;
			this.dgControl.PreferredRowHeight = 22;
			this.dgControl.ProcessAcross = true;
			this.dgControl.RowHeadersVisible = false;
			this.dgControl.Size = new System.Drawing.Size(696, 92);
			this.dgControl.TabIndex = 0;
			this.dgControl.ToolTipColumn = -1;
			this.dgControl.Resize += new System.EventHandler(this.dgControl_Resize);
			this.dgControl.CurrentCellChanged += new System.EventHandler(this.dgControl_CurrentCellChanged);
			// 
			// dgPhenotype
			// 
			this.dgPhenotype.AllowSorting = false;
			this.dgPhenotype.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dgPhenotype.CaptionFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgPhenotype.CaptionVisible = false;
			this.dgPhenotype.DataMember = string.Empty;
			this.dgPhenotype.Direction = gov.va.med.vbecs.GUI.controls.GridDirection.Up;
			this.dgPhenotype.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgPhenotype.HeaderFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgPhenotype.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.dgPhenotype.Location = new System.Drawing.Point(0, 92);
			this.dgPhenotype.Name = "dgPhenotype";
			this.dgPhenotype.PhenotypeControlDataGrid = null;
			this.dgPhenotype.PreferredRowHeight = 22;
			this.dgPhenotype.ProcessAcross = true;
			this.dgPhenotype.RowHeadersVisible = false;
			this.dgPhenotype.Size = new System.Drawing.Size(696, 172);
			this.dgPhenotype.TabIndex = 1;
			this.dgPhenotype.ToolTipColumn = -1;
			this.dgPhenotype.Resize += new System.EventHandler(this.dgPhenotype_Resize);
			this.dgPhenotype.CurrentCellChanged += new System.EventHandler(this.dgPhenotype_CurrentCellChanged);
			// 
			// cmbLotNumber
			// 
			this.cmbLotNumber.DropDownWidth = 150;
			this.cmbLotNumber.Interval = 300;
			this.cmbLotNumber.Location = new System.Drawing.Point(0, 0);
			this.cmbLotNumber.MaxLength = 15;
			this.cmbLotNumber.Name = "cmbLotNumber";
			this.cmbLotNumber.Size = new System.Drawing.Size(93, 21);
			this.cmbLotNumber.TabIndex = 0;
			this.cmbLotNumber.KeyDown += new System.Windows.Forms.KeyEventHandler(this.cmbLotNumber_KeyDown);
			this.cmbLotNumber.TextChanged += new System.EventHandler(this.cmbLotNumber_TextChanged);
			// 
			// cmbReagentType
			// 
			this.cmbReagentType.DropDownWidth = 150;
			this.cmbReagentType.Interval = 300;
			this.cmbReagentType.Location = new System.Drawing.Point(0, 0);
			this.cmbReagentType.MaxLength = 25;
			this.cmbReagentType.Name = "cmbReagentType";
			this.cmbReagentType.Size = new System.Drawing.Size(103, 21);
			this.cmbReagentType.TabIndex = 0;
			this.cmbReagentType.KeyDown += new System.Windows.Forms.KeyEventHandler(this.cmbReagentType_KeyDown);
			this.cmbReagentType.TextChanged += new System.EventHandler(this.cmbReagentType_TextChanged);
			// 
			// cmbControlComment
			// 
			this.cmbControlComment.DropDownWidth = 250;
			this.cmbControlComment.Interval = 300;
			this.cmbControlComment.Location = new System.Drawing.Point(0, 0);
			this.cmbControlComment.MaxLength = 255;
			this.cmbControlComment.Name = "cmbControlComment";
			this.cmbControlComment.Size = new System.Drawing.Size(98, 21);
			this.cmbControlComment.TabIndex = 0;
			this.cmbControlComment.KeyDown += new System.Windows.Forms.KeyEventHandler(this.cmbControlComment_KeyDown);
			this.cmbControlComment.TextChanged += new System.EventHandler(this.cmbControlComment_TextChanged);
			// 
			// cmbComment
			// 
			this.cmbComment.DropDownWidth = 250;
			this.cmbComment.Interval = 300;
			this.cmbComment.Location = new System.Drawing.Point(0, 0);
			this.cmbComment.MaxLength = 255;
			this.cmbComment.Name = "cmbComment";
			this.cmbComment.Size = new System.Drawing.Size(98, 21);
			this.cmbComment.TabIndex = 0;
			this.cmbComment.KeyDown += new System.Windows.Forms.KeyEventHandler(this.cmbComment_KeyDown);
			this.cmbComment.TextChanged += new System.EventHandler(this.cmbComment_TextChanged);
			// 
			// cmbWeakDComment
			// 
			this.cmbWeakDComment.DropDownWidth = 250;
			this.cmbWeakDComment.Interval = 300;
			this.cmbWeakDComment.Location = new System.Drawing.Point(0, 0);
			this.cmbWeakDComment.MaxLength = 255;
			this.cmbWeakDComment.Name = "cmbWeakDComment";
			this.cmbWeakDComment.Size = new System.Drawing.Size(148, 21);
			this.cmbWeakDComment.TabIndex = 0;
			this.cmbWeakDComment.KeyDown += new System.Windows.Forms.KeyEventHandler(this.cmbWeakDComment_KeyDown);
			this.cmbWeakDComment.TextChanged += new System.EventHandler(this.cmbWeakDComment_TextChanged);
			// 
			// grpLot
			// 
			this.grpLot.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpLot.Controls.Add(this.txtExpires);
			this.grpLot.Controls.Add(this.lblExpires);
			this.grpLot.Controls.Add(this.txtManufacturer);
			this.grpLot.Controls.Add(this.lblManufacturer);
			this.grpLot.Controls.Add(this.txtLotNumber);
			this.grpLot.Controls.Add(this.lblLotNumber);
			this.grpLot.Location = new System.Drawing.Point(0, 260);
			this.grpLot.Name = "grpLot";
			this.grpLot.Size = new System.Drawing.Size(696, 40);
			this.grpLot.TabIndex = 4;
			this.grpLot.TabStop = false;
			// 
			// txtExpires
			// 
			this.txtExpires.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.txtExpires.Location = new System.Drawing.Point(580, 12);
			this.txtExpires.Name = "txtExpires";
			this.txtExpires.ReadOnly = true;
			this.txtExpires.Size = new System.Drawing.Size(108, 20);
			this.txtExpires.TabIndex = 2;
			this.txtExpires.Text = string.Empty;
			// 
			// lblExpires
			// 
			this.lblExpires.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.lblExpires.Location = new System.Drawing.Point(540, 12);
			this.lblExpires.Name = "lblExpires";
			this.lblExpires.Size = new System.Drawing.Size(48, 20);
			this.lblExpires.TabIndex = 6;
			this.lblExpires.Text = "Expires";
			this.lblExpires.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtManufacturer
			// 
			this.txtManufacturer.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtManufacturer.Location = new System.Drawing.Point(288, 12);
			this.txtManufacturer.Name = "txtManufacturer";
			this.txtManufacturer.ReadOnly = true;
			this.txtManufacturer.Size = new System.Drawing.Size(228, 20);
			this.txtManufacturer.TabIndex = 1;
			this.txtManufacturer.Text = string.Empty;
			// 
			// lblManufacturer
			// 
			this.lblManufacturer.Location = new System.Drawing.Point(220, 12);
			this.lblManufacturer.Name = "lblManufacturer";
			this.lblManufacturer.Size = new System.Drawing.Size(72, 20);
			this.lblManufacturer.TabIndex = 4;
			this.lblManufacturer.Text = ARTIFICIAL.Manufacturer;
			this.lblManufacturer.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtLotNumber
			// 
			this.txtLotNumber.Location = new System.Drawing.Point(64, 12);
			this.txtLotNumber.Name = "txtLotNumber";
			this.txtLotNumber.ReadOnly = true;
			this.txtLotNumber.Size = new System.Drawing.Size(132, 20);
			this.txtLotNumber.TabIndex = 0;
			this.txtLotNumber.Text = string.Empty;
			// 
			// lblLotNumber
			// 
			this.lblLotNumber.Location = new System.Drawing.Point(4, 12);
			this.lblLotNumber.Name = "lblLotNumber";
			this.lblLotNumber.Size = new System.Drawing.Size(64, 20);
			this.lblLotNumber.TabIndex = 0;
			this.lblLotNumber.Text = "Lot Number";
			this.lblLotNumber.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnInvalidateResults
			// 
			this.btnInvalidateResults.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnInvalidateResults.Image = ((System.Drawing.Image)(resources.GetObject("btnInvalidateResults.Image")));
			this.btnInvalidateResults.Location = new System.Drawing.Point(674, 0);
			this.btnInvalidateResults.Name = "btnInvalidateResults";
			this.btnInvalidateResults.Size = new System.Drawing.Size(20, 20);
			this.btnInvalidateResults.TabIndex = 3;
			this.btnInvalidateResults.MouseHover += new System.EventHandler(this.btnInvalidateResults_MouseHover);
			// 
			// dgWeakD
			// 
			this.dgWeakD.AllowSorting = false;
			this.dgWeakD.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dgWeakD.CaptionFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgWeakD.CaptionText = "Unit Weak D Typing";
			this.dgWeakD.CaptionVisible = false;
			this.dgWeakD.DataMember = string.Empty;
			this.dgWeakD.Direction = gov.va.med.vbecs.GUI.controls.GridDirection.Up;
			this.dgWeakD.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgWeakD.HeaderFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgWeakD.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.dgWeakD.Location = new System.Drawing.Point(0, 0);
			this.dgWeakD.Name = "dgWeakD";
			this.dgWeakD.ProcessAcross = true;
			this.dgWeakD.RowHeadersVisible = false;
			this.dgWeakD.Size = new System.Drawing.Size(696, 260);
			this.dgWeakD.TabIndex = 2;
			this.dgWeakD.ToolTipColumn = -1;
			this.dgWeakD.Visible = false;
			this.dgWeakD.Resize += new System.EventHandler(this.dgWeakD_Resize);
			this.dgWeakD.CurrentCellChanged += new System.EventHandler(this.dgWeakD_CurrentCellChanged);
			// 
			// ttToolTip
			// 
			this.ttToolTip.ShowAlways = true;
			// 
			// DataGridUnitPhenotype
			// 
			this.Controls.Add(this.btnInvalidateResults);
			this.Controls.Add(this.dgPhenotype);
			this.Controls.Add(this.dgControl);
			this.Controls.Add(this.grpLot);
			this.Controls.Add(this.dgWeakD);
			this.Name = "DataGridUnitPhenotype";
			this.Size = new System.Drawing.Size(696, 300);
			((System.ComponentModel.ISupportInitialize)(this.dgControl)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.dgPhenotype)).EndInit();
			this.grpLot.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.dgWeakD)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		#region Properties

		/// <summary>
		/// Get InvalidateResultsButton
		/// </summary>
		public Button InvalidateResultsButton
		{
			get
			{
				return this.btnInvalidateResults;
			}
		}

		/// <summary>
		/// Get/Set EnableQCGrid
		/// </summary>
		public bool EnableQCGrid
		{
			get
			{
				return this.dgControl.Enabled;
			}
			set
			{
				this.dgControl.Enabled = value;
			}
		}

		/// <summary>
		/// Get/Set ValidEntries
		/// </summary>
		public string ValidEntries
		{
			get
			{
				return this._validEntries;
			}
		}

		/// <summary>
		/// Get/Set TestPhases
		/// </summary>
		public Common.ReactivityPhase TestPhases
		{
			get
			{
				return this._testPhases;
			}
			set
			{
				this._testPhases = value;
			}
		}

		/// <summary>
		/// Antigen Typing Task Status
		/// Implements BR_41.20
		/// </summary>
		public Common.TaskStatus TaskStatus
		{
			get
			{
				if (this.dgControl.DataSource != null)
				{
					DataTable dtControl = ((DataView)this.dgControl.DataSource).Table;
					//
					foreach(DataRow drControl in dtControl.Rows)
					{
						if ((drControl[ARTIFICIAL.Indicator].ToString() == string.Empty) || (drControl[ARTIFICIAL.Indicator].ToString() == "E"))
						{
							return Common.TaskStatus.PartiallyCompleted;
						}
					}
				}
				if (this.dgPhenotype.DataSource != null)
				{
					DataTable dtPhenotype = ((DataView)this.dgPhenotype.DataSource).Table;
					//
					foreach(DataRow drPhenotype in dtPhenotype.Rows)
					{
						if ((drPhenotype[ARTIFICIAL.Indicator].ToString() == string.Empty) || (drPhenotype[ARTIFICIAL.Indicator].ToString() == "E"))
						{
							return Common.TaskStatus.PartiallyCompleted;
						}
					}
				}
				if (this.dgWeakD.DataSource != null)
				{
					DataTable dtWeakD = ((DataView)this.dgWeakD.DataSource).Table;
					//
					foreach(DataRow drWeakD in dtWeakD.Rows)
					{
						if ((drWeakD[ARTIFICIAL.Indicator].ToString() == string.Empty) || (drWeakD[ARTIFICIAL.Indicator].ToString() == "E"))
						{
							return Common.TaskStatus.PartiallyCompleted;
						}
					}
				}
				return Common.TaskStatus.Completed;
			}
		}

		/// <summary>
		/// Get/Set TestingDate
		/// </summary>
		public DateTime TestingDate
		{
			get
			{
				return this._testingDate;
			}
			set
			{
				this._testingDate = value;
			}
		}

		/// <summary>
		/// CR 2864
		/// </summary>
		public bool UserSwitchingTabs
		{
			set
			{
				this._userSwitchingTabs = value;
			}
			get
			{
				return this._userSwitchingTabs;
			}
		}

		#endregion

		#region Initialize Grids

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// Calls the method to create a hash table of testing results, creates the blood unit test table, 
		/// populates the table with the selected units, and sets the current cell to allow editing.
		/// </summary>
		private void InitializeControlGrid()
		{
			this.dgControl.CaptionVisible = true;
			this.dgControl.PhenotypeDataGrid = this.dgPhenotype;
			this.dgControl.Direction = GridDirection.Down;
			this.AddControlCustomDataTableStyle();
			this.dgControl.ToolTipColumn = 18;
			//
			this.dgControl.Enter += new System.EventHandler(dgControl_Enter);
			this.dgControl.LostFocus += new System.EventHandler(dgControl_LostFocus);
			_keyPressEventHandledPheno = false;
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// Calls the method to create a hash table of testing results, creates the blood unit test table, 
		/// populates the table with the selected units, and sets the current cell to allow editing.
		/// </summary>
		private void InitializePhenotypeGrid()
		{
			this.dgPhenotype.CaptionVisible = false;
			this.dgPhenotype.PhenotypeControlDataGrid = this.dgControl;
			this.dgPhenotype.Direction = GridDirection.Down;
			this.AddPhenotypeCustomDataTableStyle();
			this.dgPhenotype.ToolTipColumn = 15;
			//
			this.dgPhenotype.Enter += new System.EventHandler(dgPhenotype_Enter);
			this.dgPhenotype.LostFocus += new System.EventHandler(dgPhenotype_LostFocus);
			_keyPressEventHandledPheno = false;
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// Calls the method to create a hash table of testing results, creates the blood unit test table, 
		/// populates the table with the selected units, and sets the current cell to allow editing.
		/// </summary>
		private void InitializeWeakDGrid()
		{
			this.dgWeakD.CaptionVisible = true;
			this.dgWeakD.Direction = GridDirection.Down;
			this.AddWeakDCustomDataTableStyle();
			this.dgWeakD.ToolTipColumn = 17;
			//
			this.dgWeakD.Enter += new System.EventHandler(dgWeakD_Enter);
			this.dgWeakD.LostFocus +=new EventHandler(dgWeakD_LostFocus);
			_keyPressEventHandledWeakD = false;
		}

		#endregion

		#region Populate Grids

		/// <summary>
		/// Populate Unit Antigen Typing Grid
		/// Implements BR_41.18, BR_41.21
		/// </summary>
		/// <param name="dtUnits"></param>
		/// <param name="drRackLot"></param>
		/// <returns></returns>
		public DataTable CreatePhenotypeDataTable(DataTable dtUnits,DataRow drRackLot)
		{
			DataTable dt = CreatePhenotypeTestTable();
			//
			DataRow drReagent = BOL.Reagent.GetReagent((Guid)drRackLot[TABLE.RackLot.ReagentGuid]);
			//
			foreach(DataRow drUnit in dtUnits.Rows)
			{
				DataRow dr = dt.NewRow();
				dr[ARTIFICIAL.Indicator] = string.Empty;
				//BR_41.18, BR_41.21
				dr[TABLE.ExceptionAntigenTest.UnitId] = drUnit[TABLE.BloodUnit.EyeReadableUnitId];
				dr[TABLE.BloodProduct.ProductName] = drUnit[TABLE.BloodProduct.ProductShortName]+", "+
					BOL.BloodUnit.GetFullProductCode((Common.BarcodeType)Convert.ToChar(drUnit[TABLE.BloodUnit.LabelTypeCode]),drUnit[TABLE.BloodUnit.UnitProductCode].ToString(),Convert.ToChar(drUnit[TABLE.DonationType.DonationTypeCode]),drUnit[TABLE.BloodUnit.UnitDivisionId].ToString());
				dr[ARTIFICIAL.IS] = string.Empty;
				dr[ARTIFICIAL.RT] = string.Empty;
				dr[ARTIFICIAL.C37] = string.Empty;
				dr[ARTIFICIAL.AHG] = string.Empty;
				dr[ARTIFICIAL.CC] = string.Empty;
				dr[ARTIFICIAL.Interp] = string.Empty;
				dr[ARTIFICIAL.Comment] = string.Empty;
				dr[TABLE.ValidRhResult.SystemInterp] = string.Empty;
				dr[TABLE.BloodUnit.BloodUnitGuid] = drUnit[TABLE.BloodUnit.BloodUnitGuid];
				dr[TABLE.Reagent.ReagentGuid] = drReagent[TABLE.Reagent.ReagentGuid];
				dr[TABLE.ReactivityPhase.ReactivityPhaseCode] = drRackLot[TABLE.ReactivityPhase.ReactivityPhaseCode];
				dr[TABLE.OrderableTest.OrderableTestId] = drRackLot[TABLE.OrderableTest.OrderableTestId];
				dr[ARTIFICIAL.IndicatorMessage] = string.Empty;
				dr[ARTIFICIAL.PartiallyCompleted] = false;
				dr[ARTIFICIAL.ISGuid] = Guid.Empty;
				dr[ARTIFICIAL.RTGuid] = Guid.Empty;
				dr[ARTIFICIAL.C37Guid] = Guid.Empty;
				dr[ARTIFICIAL.AHGGuid] = Guid.Empty;
				dr[ARTIFICIAL.CCGuid] = Guid.Empty;
				dr[ARTIFICIAL.InterpGuid] = Guid.Empty;
				dr[ARTIFICIAL.ISRowVersion] = DBNull.Value;
				dr[ARTIFICIAL.RTRowVersion] = DBNull.Value;
				dr[ARTIFICIAL.C37RowVersion] = DBNull.Value;
				dr[ARTIFICIAL.AHGRowVersion] = DBNull.Value;
				dr[ARTIFICIAL.CCRowVersion] = DBNull.Value;
				dr[ARTIFICIAL.InterpRowVersion] = DBNull.Value;
				dr[ARTIFICIAL.ISSave] = true;
				dr[ARTIFICIAL.RTSave] = true;
				dr[ARTIFICIAL.C37Save] = true;
				dr[ARTIFICIAL.AHGSave] = true;
				dr[ARTIFICIAL.CCSave] = true;
				dr[ARTIFICIAL.InterpSave] = true;
				dr[TABLE.BloodUnitStatus.QuarantineIndicator] = false;
				dr[TABLE.ExceptionQc.ExceptionComment] = DBNull.Value;
				//
				DataTable results = BOL.AntiseraWorklist.GetTestResultsForAntiseraWorklist((Guid)drUnit[TABLE.BloodUnit.BloodUnitGuid],(Guid)drRackLot[TABLE.AntiseraWorklistTyping.AntiseraWorklistTypingGuid]);
				//
				DataTable testTypes = BOL.BloodTestType.GetBloodTestTypes(drRackLot[TABLE.OrderableTest.OrderableTestId].ToString());
				//
				foreach(DataRow result in results.Rows)
				{
					DataRow[] relevantTest = testTypes.Select(TABLE.BloodTestType.BloodTestTypeId + " = '" + result[TABLE.BloodTestType.BloodTestTypeId].ToString() + "'");
					if (relevantTest.Length >0)
					{
						string bloodTestType = relevantTest[0][TABLE.BloodTestType.BloodTestName].ToString();
						if (bloodTestType.IndexOf(ARTIFICIAL.IS) > -1)
						{
							dr[ARTIFICIAL.IS] = result[TABLE.BloodUnitTest.TestResultId].ToString().Trim();
							dr[ARTIFICIAL.ISGuid] = result[TABLE.BloodUnitTest.BloodUnitTestGuid];
							dr[ARTIFICIAL.ISRowVersion] = result[TABLE.BloodUnitTest.RowVersion];
							if (result[TABLE.BloodUnitTest.TestComments].ToString().Length>0)
							{
								dr[ARTIFICIAL.Comment] = result[TABLE.BloodUnitTest.TestComments];
							}
							if (dr[ARTIFICIAL.IS].ToString().Length>0)
							{
								dr[ARTIFICIAL.ISSave] = false;
							}
						}
						else if (bloodTestType.IndexOf(ARTIFICIAL.RT) > -1)
						{
							dr[ARTIFICIAL.RT] = result[TABLE.BloodUnitTest.TestResultId].ToString().Trim();
							dr[ARTIFICIAL.RTGuid] = result[TABLE.BloodUnitTest.BloodUnitTestGuid];
							dr[ARTIFICIAL.RTRowVersion] = result[TABLE.BloodUnitTest.RowVersion];
							if (result[TABLE.BloodUnitTest.TestComments].ToString().Length>0)
							{
								dr[ARTIFICIAL.Comment] = result[TABLE.BloodUnitTest.TestComments];
							}
							if (dr[ARTIFICIAL.RT].ToString().Length>0)
							{
								dr[ARTIFICIAL.RTSave] = false;
							}
						}
						else if (bloodTestType.IndexOf(ARTIFICIAL.C37) > -1)
						{
							dr[ARTIFICIAL.C37] = result[TABLE.BloodUnitTest.TestResultId].ToString().Trim();
							dr[ARTIFICIAL.C37Guid] = result[TABLE.BloodUnitTest.BloodUnitTestGuid];
							dr[ARTIFICIAL.C37RowVersion] = result[TABLE.BloodUnitTest.RowVersion];
							if (result[TABLE.BloodUnitTest.TestComments].ToString().Length>0)
							{
								dr[ARTIFICIAL.Comment] = result[TABLE.BloodUnitTest.TestComments];
							}
							if (dr[ARTIFICIAL.C37].ToString().Length>0)
							{
								dr[ARTIFICIAL.C37Save] = false;
							}
						}
						else if (bloodTestType.IndexOf(ARTIFICIAL.AHG) > -1)
						{
							dr[ARTIFICIAL.AHG] = result[TABLE.BloodUnitTest.TestResultId].ToString().Trim();
							dr[ARTIFICIAL.AHGGuid] = result[TABLE.BloodUnitTest.BloodUnitTestGuid];
							dr[ARTIFICIAL.AHGRowVersion] = result[TABLE.BloodUnitTest.RowVersion];
							if (result[TABLE.BloodUnitTest.TestComments].ToString().Length>0)
							{
								dr[ARTIFICIAL.Comment] = result[TABLE.BloodUnitTest.TestComments];
							}
							if (dr[ARTIFICIAL.AHG].ToString().Length>0)
							{
								dr[ARTIFICIAL.AHGSave] = false;
							}
						}
						else if (bloodTestType.IndexOf(ARTIFICIAL.CC) > -1)
						{
							dr[ARTIFICIAL.CC] = result[TABLE.BloodUnitTest.TestResultId].ToString().Trim();
							dr[ARTIFICIAL.CCGuid] = result[TABLE.BloodUnitTest.BloodUnitTestGuid];
							dr[ARTIFICIAL.CCRowVersion] = result[TABLE.BloodUnitTest.RowVersion];
							if (result[TABLE.BloodUnitTest.TestComments].ToString().Length>0)
							{
								dr[ARTIFICIAL.Comment] = result[TABLE.BloodUnitTest.TestComments];
							}
							if (dr[ARTIFICIAL.CC].ToString().Length>0)
							{
								dr[ARTIFICIAL.CCSave] = false;
							}
						}
						else if (bloodTestType.IndexOf(ARTIFICIAL.Interp) > -1)
						{
							dr[ARTIFICIAL.Interp] = result[TABLE.BloodUnitTest.TestResultId].ToString().Trim();
							dr[ARTIFICIAL.InterpGuid] = result[TABLE.BloodUnitTest.BloodUnitTestGuid];
							dr[ARTIFICIAL.InterpRowVersion] = result[TABLE.BloodUnitTest.RowVersion];
							if (result[TABLE.BloodUnitTest.TestComments].ToString().Length>0)
							{
								dr[ARTIFICIAL.Comment] = result[TABLE.BloodUnitTest.TestComments];
							}
							if (dr[ARTIFICIAL.Interp].ToString().Length>0)
							{
								dr[ARTIFICIAL.InterpSave] = false;
							}
						}
					}
				}
				//
				dt.Rows.Add(dr);
			}
			//
			return dt;
		}

		/// <summary>
		/// Populate Unit Antigen Typing QC Grid
		/// Implements BR_41.21
		/// </summary>
		/// <param name="drRackLot"></param>
		/// <returns></returns>
		public DataTable CreateControlDataTable(DataRow drRackLot)
		{
			DataTable dt = CreateControlTestTable();
			this.dgControl.Enabled = true;
			//
			DataRow drPos = dt.NewRow();
			drPos[ARTIFICIAL.Indicator] = string.Empty;
			drPos[ARTIFICIAL.Control] = "POS";
			drPos[ARTIFICIAL.ReagentType] = string.Empty;
			drPos[TABLE.Reagent.LotNumber] = string.Empty;
			drPos[ARTIFICIAL.VialId] = string.Empty;
			drPos[ARTIFICIAL.IS] = string.Empty;
			drPos[ARTIFICIAL.RT] = string.Empty;
			drPos[ARTIFICIAL.C37] = string.Empty;
			drPos[ARTIFICIAL.AHG] = string.Empty;
			drPos[ARTIFICIAL.CC] = string.Empty;
			drPos[ARTIFICIAL.ControlInterp] = string.Empty;
			drPos[ARTIFICIAL.ControlComment] = string.Empty;
			drPos[ARTIFICIAL.SystemControlInterp] = string.Empty;
			drPos[TABLE.Reagent.ReagentGuid] = drRackLot[TABLE.RackLot.ReagentGuid];
			drPos[ARTIFICIAL.ControlReagentGuid] = Guid.Empty;
			drPos[TABLE.Reagent.ReagentManufacturerName] = string.Empty;
			drPos[TABLE.Reagent.LotExpirationDate] = DateTime.MinValue;
			drPos[TABLE.ReactivityPhase.ReactivityPhaseCode] = drRackLot[TABLE.ReactivityPhase.ReactivityPhaseCode];
			drPos[ARTIFICIAL.IndicatorMessage] = string.Empty;
			drPos[ARTIFICIAL.PartiallyCompleted] = false;
			drPos[ARTIFICIAL.ISGuid] = Guid.Empty;
			drPos[ARTIFICIAL.RTGuid] = Guid.Empty;
			drPos[ARTIFICIAL.C37Guid] = Guid.Empty;
			drPos[ARTIFICIAL.AHGGuid] = Guid.Empty;
			drPos[ARTIFICIAL.CCGuid] = Guid.Empty;
			drPos[ARTIFICIAL.ControlInterpGuid] = Guid.Empty;
			drPos[ARTIFICIAL.ISRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.RTRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.C37RowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.AHGRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.CCRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.InterpRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.ISSave] = true;
			drPos[ARTIFICIAL.RTSave] = true;
			drPos[ARTIFICIAL.C37Save] = true;
			drPos[ARTIFICIAL.AHGSave] = true;
			drPos[ARTIFICIAL.CCSave] = true;
			drPos[ARTIFICIAL.ControlInterpSave] = true;
			drPos[TABLE.VamcDivision.DivisionCode] = drRackLot[TABLE.RackLot.DivisionCode].ToString();
			drPos[TABLE.ReagentTestParameter.TestWithId] = DBNull.Value;
			drPos[ARTIFICIAL.OverrideComment] = DBNull.Value;
			//
			dt.Rows.Add(drPos);
			//
			DataRow drNeg = dt.NewRow();
			drNeg[ARTIFICIAL.Indicator] = string.Empty;
			drNeg[ARTIFICIAL.Control] = "NEG";
			drNeg[ARTIFICIAL.ReagentType] = string.Empty;
			drNeg[TABLE.Reagent.LotNumber] = string.Empty;
			drNeg[ARTIFICIAL.VialId] = string.Empty;
			drNeg[ARTIFICIAL.IS] = string.Empty;
			drNeg[ARTIFICIAL.RT] = string.Empty;
			drNeg[ARTIFICIAL.C37] = string.Empty;
			drNeg[ARTIFICIAL.AHG] = string.Empty;
			drNeg[ARTIFICIAL.CC] = string.Empty;
			drNeg[ARTIFICIAL.ControlInterp] = string.Empty;
			drNeg[ARTIFICIAL.ControlComment] = string.Empty;
			drNeg[ARTIFICIAL.SystemControlInterp] = string.Empty;
			drNeg[TABLE.Reagent.ReagentGuid] = drRackLot[TABLE.RackLot.ReagentGuid];
			drNeg[ARTIFICIAL.ControlReagentGuid] = Guid.Empty;
			drNeg[TABLE.Reagent.ReagentManufacturerName] = string.Empty;
			drNeg[TABLE.Reagent.LotExpirationDate] = DateTime.MinValue;
			drNeg[TABLE.ReactivityPhase.ReactivityPhaseCode] = drRackLot[TABLE.RackLot.ReactivityPhaseCode];
			drNeg[ARTIFICIAL.IndicatorMessage] = string.Empty;
			drNeg[ARTIFICIAL.PartiallyCompleted] = false;
			drNeg[ARTIFICIAL.ISGuid] = Guid.Empty;
			drNeg[ARTIFICIAL.RTGuid] = Guid.Empty;
			drNeg[ARTIFICIAL.C37Guid] = Guid.Empty;
			drNeg[ARTIFICIAL.AHGGuid] = Guid.Empty;
			drNeg[ARTIFICIAL.CCGuid] = Guid.Empty;
			drNeg[ARTIFICIAL.ControlInterpGuid] = Guid.Empty;
			drNeg[ARTIFICIAL.ISRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.RTRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.C37RowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.AHGRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.CCRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.InterpRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.ISSave] = true;
			drNeg[ARTIFICIAL.RTSave] = true;
			drNeg[ARTIFICIAL.C37Save] = true;
			drNeg[ARTIFICIAL.AHGSave] = true;
			drNeg[ARTIFICIAL.CCSave] = true;
			drNeg[ARTIFICIAL.ControlInterpSave] = true;
			drNeg[TABLE.VamcDivision.DivisionCode] = drRackLot[TABLE.RackLot.DivisionCode].ToString();
			drNeg[TABLE.ReagentTestParameter.TestWithId] = DBNull.Value;
			drNeg[ARTIFICIAL.OverrideComment] = DBNull.Value;
			//
			dt.Rows.Add(drNeg);
			//
			return dt;
		}

		/// <summary>
		/// CreateControlDataTable
		/// </summary>
		/// <returns></returns>
		public DataTable CreateControlDataTable()
		{
			DataTable dt = CreateControlTestTable();
			this.dgControl.Enabled = false;
			return dt;
		}

		/// <summary>
		/// CreateControlDataTable
		/// </summary>
		/// <param name="drRackLot"></param>
		/// <param name="qcResults"></param>
		/// <param name="dtWorklistQCControls"></param>
		/// <returns></returns>
		public DataTable CreateControlDataTable(DataRow drRackLot, DataTable qcResults, DataTable dtWorklistQCControls)
		{
			DataTable dt = this.CreateControlDataTable(drRackLot);
			//
			DataRow drPos = dt.Rows[0];
			DataRow drNeg = dt.Rows[1];
			//
			if (dtWorklistQCControls.Rows.Count==2)
			{
				DataRow drPosControl = dtWorklistQCControls.Select(TABLE.RackLot.ControlCellId + " = true")[0];
				drPos[ARTIFICIAL.ControlReagentGuid] = drPosControl[TABLE.RackLot.ReagentGuid];
				drPos[ARTIFICIAL.ReagentType] = drPosControl[TABLE.ReagentType.ReagentTypeName];
				drPos[TABLE.Reagent.LotNumber] = drPosControl[TABLE.Reagent.LotNumber];
				drPos[ARTIFICIAL.VialId] = drPosControl[TABLE.RackLot.LotVialNumber];
				drPos[ARTIFICIAL.ControlComment] = drPosControl[TABLE.RackLot.Comments].ToString();
				drPos[ARTIFICIAL.PartiallyCompleted] = true;
				//
				DataRow drNegControl = dtWorklistQCControls.Select(TABLE.RackLot.ControlCellId + " = false")[0];
				drNeg[ARTIFICIAL.ControlReagentGuid] = drNegControl[TABLE.RackLot.ReagentGuid];
				drNeg[ARTIFICIAL.ReagentType] = drNegControl[TABLE.ReagentType.ReagentTypeName];
				drNeg[TABLE.Reagent.LotNumber] = drNegControl[TABLE.Reagent.LotNumber];
				drNeg[ARTIFICIAL.VialId] = drNegControl[TABLE.RackLot.LotVialNumber];
				drNeg[ARTIFICIAL.ControlComment] = drNegControl[TABLE.RackLot.Comments].ToString();
				drNeg[ARTIFICIAL.PartiallyCompleted] = true;
			}
			//
			foreach(DataRow result in qcResults.Rows)
			{
				string phase = result[TABLE.RackTest.RackTestResultTypeCode].ToString().Trim();
				//
				DataRow dr;
				if ((bool)result[TABLE.RackLot.ControlCellId])
				{
					dr = drPos;
					//
					drPos[ARTIFICIAL.InterpRowVersion] = result[ARTIFICIAL.RackLotRowVersion];
					drPos[ARTIFICIAL.ControlInterpGuid] = result[TABLE.RackLot.RackLotGuid];
					drPos[TABLE.ReagentTestParameter.TestWithId] = result[TABLE.RackLot.TestWithId];
					if (!result.IsNull(TABLE.RackLot.SatisfactoryResultIndicator))
					{
						if ((bool)result[TABLE.RackLot.SatisfactoryResultIndicator])
						{
							drPos[ARTIFICIAL.ControlInterp] = "P";
						}
						else
						{
							drPos[ARTIFICIAL.ControlInterp] = "I";
						}
						drPos[ARTIFICIAL.ControlInterpSave] = false;
					}
				}
				else
				{
					dr = drNeg;
					//
					drNeg[ARTIFICIAL.InterpRowVersion] = result[ARTIFICIAL.RackLotRowVersion];
					drNeg[ARTIFICIAL.ControlInterpGuid] = result[TABLE.RackLot.RackLotGuid];
					drNeg[TABLE.ReagentTestParameter.TestWithId] = result[TABLE.RackLot.TestWithId];
					if (!result.IsNull(TABLE.RackLot.SatisfactoryResultIndicator))
					{
						if ((bool)result[TABLE.RackLot.SatisfactoryResultIndicator])
						{
							drNeg[ARTIFICIAL.ControlInterp] = "N";
						}
						else
						{
							drNeg[ARTIFICIAL.ControlInterp] = "I";
						}
						drNeg[ARTIFICIAL.ControlInterpSave] = false;
					}
				}
				//
				if (phase == ARTIFICIAL.IS)
				{
					dr[ARTIFICIAL.IS] = result[TABLE.RackTest.RackTestResult].ToString().Trim();
					dr[ARTIFICIAL.ISGuid] = result[TABLE.RackTest.RackTestGuid];
					dr[ARTIFICIAL.ISRowVersion] = result[TABLE.RackTest.RowVersion];
					if (dr[ARTIFICIAL.IS].ToString().Length>0)
					{
						dr[ARTIFICIAL.ISSave] = false;
					}
				}
				else if (phase == ARTIFICIAL.RT)
				{
					dr[ARTIFICIAL.RT] = result[TABLE.RackTest.RackTestResult].ToString().Trim();
					dr[ARTIFICIAL.RTGuid] = result[TABLE.RackTest.RackTestGuid];
					dr[ARTIFICIAL.RTRowVersion] = result[TABLE.RackTest.RowVersion];
					if (dr[ARTIFICIAL.RT].ToString().Length>0)
					{
						dr[ARTIFICIAL.RTSave] = false;
					}
				}
				else if (phase == ARTIFICIAL.C37)
				{
					dr[ARTIFICIAL.C37] = result[TABLE.RackTest.RackTestResult].ToString().Trim();
					dr[ARTIFICIAL.C37Guid] = result[TABLE.RackTest.RackTestGuid];
					dr[ARTIFICIAL.C37RowVersion] = result[TABLE.RackTest.RowVersion];
					if (dr[ARTIFICIAL.C37].ToString().Length>0)
					{
						dr[ARTIFICIAL.C37Save] = false;
					}
				}
				else if (phase == ARTIFICIAL.AHG)
				{
					dr[ARTIFICIAL.AHG] = result[TABLE.RackTest.RackTestResult].ToString().Trim();
					dr[ARTIFICIAL.AHGGuid] = result[TABLE.RackTest.RackTestGuid];
					dr[ARTIFICIAL.AHGRowVersion] = result[TABLE.RackTest.RowVersion];
					if (dr[ARTIFICIAL.AHG].ToString().Length>0)
					{
						dr[ARTIFICIAL.AHGSave] = false;
					}
				}
				else if (phase == ARTIFICIAL.CC)
				{
					dr[ARTIFICIAL.CC] = result[TABLE.RackTest.RackTestResult].ToString().Trim();
					dr[ARTIFICIAL.CCGuid] = result[TABLE.RackTest.RackTestGuid];
					dr[ARTIFICIAL.CCRowVersion] = result[TABLE.RackTest.RowVersion];
					if (dr[ARTIFICIAL.CC].ToString().Length>0)
					{
						dr[ARTIFICIAL.CCSave] = false;
					}
				}
				//
			}
			//
			return dt;
		}

		/// <summary>
		/// Populate Weak D Typing Grid
		/// Implemements BR_41.18
		/// </summary>
		/// <param name="dtUnits"></param>
		/// <param name="drRackLot"></param>
		/// <returns></returns>
		public DataTable CreateWeakDDataTable(DataTable dtUnits,DataRow drRackLot)
		{
			DataTable dt = CreateWeakDTestTable();
			//
			DataRow drReagent = BOL.Reagent.GetReagent((Guid)drRackLot[TABLE.RackLot.ReagentGuid]);
			//
			Guid dCtrlGuid = Guid.Empty;
			//
			DataTable dtDControl = BOL.AntiseraWorklist.GetAntiseraWorklistQCControls((Guid)drRackLot[TABLE.AntiseraWorklistTyping.AntiseraWorklistTypingGuid]);
			//
			if (dtDControl.Rows.Count>0)
			{
				dCtrlGuid = (Guid)dtDControl.Rows[0][TABLE.Reagent.ReagentGuid];
			}
			//
			foreach(DataRow drUnit in dtUnits.Rows)
			{
				DataRow dr = dt.NewRow();
				dr[ARTIFICIAL.Indicator] = string.Empty;
				//BR_41.18
				dr[TABLE.ExceptionAntigenTest.UnitId] = drUnit[TABLE.BloodUnit.EyeReadableUnitId];
				dr[TABLE.BloodProduct.ProductName] = drUnit[TABLE.BloodProduct.ProductShortName]+", "+
					BOL.BloodUnit.GetFullProductCode((Common.BarcodeType)Convert.ToChar(drUnit[TABLE.BloodUnit.LabelTypeCode]),drUnit[TABLE.BloodUnit.UnitProductCode].ToString(),Convert.ToChar(drUnit[TABLE.DonationType.DonationTypeCode]),drUnit[TABLE.BloodUnit.UnitDivisionId].ToString());
				dr[ARTIFICIAL.D37] = string.Empty;
				dr[ARTIFICIAL.Dc37] = string.Empty;
				dr[ARTIFICIAL.DAHG] = string.Empty;
				dr[ARTIFICIAL.DcAHG] = string.Empty;
				dr[ARTIFICIAL.DCC] = string.Empty;
				dr[ARTIFICIAL.DcCC] = string.Empty;
				if (dCtrlGuid == Guid.Empty)
				{
					dr[ARTIFICIAL.Dc37] = DBNull.Value;
					dr[ARTIFICIAL.DcAHG] = DBNull.Value;
					dr[ARTIFICIAL.DcCC] = DBNull.Value;
				}
				dr[ARTIFICIAL.Interp] = string.Empty;
				dr[ARTIFICIAL.Comment] = string.Empty;
				dr[TABLE.ValidRhResult.SystemInterp] = string.Empty;
				dr[TABLE.BloodUnit.BloodUnitGuid] = drUnit[TABLE.BloodUnit.BloodUnitGuid];
				dr[ARTIFICIAL.AntiDReagentGuid] = drReagent[TABLE.Reagent.ReagentGuid];
				dr[ARTIFICIAL.DControlReagentGuid] = dCtrlGuid;
				dr[TABLE.ReactivityPhase.ReactivityPhaseCode] = drRackLot[TABLE.ReactivityPhase.ReactivityPhaseCode];
				dr[TABLE.OrderableTest.OrderableTestId] = drRackLot[TABLE.OrderableTest.OrderableTestId];
				dr[ARTIFICIAL.IndicatorMessage] = string.Empty;
				dr[ARTIFICIAL.PartiallyCompleted] = false;
				dr[ARTIFICIAL.D37Guid] = Guid.Empty;
				dr[ARTIFICIAL.Dc37Guid] = Guid.Empty;
				dr[ARTIFICIAL.DAHGGuid] = Guid.Empty;
				dr[ARTIFICIAL.DcAHGGuid] = Guid.Empty;
				dr[ARTIFICIAL.DCCGuid] = Guid.Empty;
				dr[ARTIFICIAL.DcCCGuid] = Guid.Empty;
				dr[ARTIFICIAL.InterpGuid] = Guid.Empty;
				dr[ARTIFICIAL.D37RowVersion] = DBNull.Value;
				dr[ARTIFICIAL.Dc37RowVersion] = DBNull.Value;
				dr[ARTIFICIAL.DAHGRowVersion] = DBNull.Value;
				dr[ARTIFICIAL.DcAHGRowVersion] = DBNull.Value;
				dr[ARTIFICIAL.DCCRowVersion] = DBNull.Value;
				dr[ARTIFICIAL.DcCCRowVersion] = DBNull.Value;
				dr[ARTIFICIAL.InterpRowVersion] = DBNull.Value;
				dr[ARTIFICIAL.D37Save] = true;
				dr[ARTIFICIAL.Dc37Save] = true;
				dr[ARTIFICIAL.DAHGSave] = true;
				dr[ARTIFICIAL.DcAHGSave] = true;
				dr[ARTIFICIAL.DCCSave] = true;
				dr[ARTIFICIAL.DcCCSave] = true;
				dr[ARTIFICIAL.InterpSave] = true;
				dr[TABLE.BloodUnitStatus.QuarantineIndicator] = false;
				dr[TABLE.VamcDivision.DivisionCode] = drRackLot[TABLE.RackLot.DivisionCode].ToString();
				dr[TABLE.Rack.RackGuid] = drRackLot[TABLE.RackLot.RackGuid];
				dr[TABLE.ExceptionQc.ExceptionComment] = DBNull.Value;
				//
				DataTable results = BOL.AntiseraWorklist.GetTestResultsForAntiseraWorklist((Guid)drUnit[TABLE.BloodUnit.BloodUnitGuid],(Guid)drRackLot[TABLE.AntiseraWorklistTyping.AntiseraWorklistTypingGuid]);
				//
				DataTable testTypes = BOL.BloodTestType.GetBloodTestTypes(drRackLot[TABLE.OrderableTest.OrderableTestId].ToString());
				//
				foreach(DataRow result in results.Rows)
				{
					DataRow[] relevantTest = testTypes.Select(TABLE.BloodTestType.BloodTestTypeId+" = '" + result[TABLE.BloodTestType.BloodTestTypeId].ToString() + "'");
					if (relevantTest.Length >0)
					{
						string bloodTestType = relevantTest[0][TABLE.BloodTestType.BloodTestName].ToString();
						if (bloodTestType.IndexOf("wD 37") > -1)
						{
							dr[ARTIFICIAL.D37] = result[TABLE.BloodUnitTest.TestResultId].ToString().Trim();
							dr[ARTIFICIAL.D37Guid] = result[TABLE.BloodUnitTest.BloodUnitTestGuid];
							dr[ARTIFICIAL.D37RowVersion] = result[TABLE.BloodUnitTest.RowVersion];
							if (result[TABLE.BloodUnitTest.TestComments].ToString().Length>0)
							{
								dr[ARTIFICIAL.Comment] = result[TABLE.BloodUnitTest.TestComments];
							}
							if (dr[ARTIFICIAL.D37].ToString().Length>0)
							{
								dr[ARTIFICIAL.D37Save] = false;
							}
						}
						else if (bloodTestType.IndexOf("D Control 37") > -1)
						{
							dr[ARTIFICIAL.Dc37] = result[TABLE.BloodUnitTest.TestResultId].ToString().Trim();
							dr[ARTIFICIAL.Dc37Guid] = result[TABLE.BloodUnitTest.BloodUnitTestGuid];
							dr[ARTIFICIAL.Dc37RowVersion] = result[TABLE.BloodUnitTest.RowVersion];
							if (result[TABLE.BloodUnitTest.TestComments].ToString().Length>0)
							{
								dr[ARTIFICIAL.Comment] = result[TABLE.BloodUnitTest.TestComments];
							}
							if (dr[ARTIFICIAL.Dc37].ToString().Length>0)
							{
								dr[ARTIFICIAL.Dc37Save] = false;
							}
						}
						else if (bloodTestType.IndexOf("wD AHG") > -1)
						{
							dr[ARTIFICIAL.DAHG] = result[TABLE.BloodUnitTest.TestResultId].ToString().Trim();
							dr[ARTIFICIAL.DAHGGuid] = result[TABLE.BloodUnitTest.BloodUnitTestGuid];
							dr[ARTIFICIAL.DAHGRowVersion] = result[TABLE.BloodUnitTest.RowVersion];
							if (result[TABLE.BloodUnitTest.TestComments].ToString().Length>0)
							{
								dr[ARTIFICIAL.Comment] = result[TABLE.BloodUnitTest.TestComments];
							}
							if (dr[ARTIFICIAL.DAHG].ToString().Length>0)
							{
								dr[ARTIFICIAL.DAHGSave] = false;
							}
						}
						else if (bloodTestType.IndexOf("D Control AHG") > -1)
						{
							dr[ARTIFICIAL.DcAHG] = result[TABLE.BloodUnitTest.TestResultId].ToString().Trim();
							dr[ARTIFICIAL.DcAHGGuid] = result[TABLE.BloodUnitTest.BloodUnitTestGuid];
							dr[ARTIFICIAL.DcAHGRowVersion] = result[TABLE.BloodUnitTest.RowVersion];
							if (result[TABLE.BloodUnitTest.TestComments].ToString().Length>0)
							{
								dr[ARTIFICIAL.Comment] = result[TABLE.BloodUnitTest.TestComments];
							}
							if (dr[ARTIFICIAL.DcAHG].ToString().Length>0)
							{
								dr[ARTIFICIAL.DcAHGSave] = false;
							}
						}
						else if (bloodTestType.IndexOf("wD CC") > -1)
						{
							dr[ARTIFICIAL.DCC] = result[TABLE.BloodUnitTest.TestResultId].ToString().Trim();
							dr[ARTIFICIAL.DCCGuid] = result[TABLE.BloodUnitTest.BloodUnitTestGuid];
							dr[ARTIFICIAL.DCCRowVersion] = result[TABLE.BloodUnitTest.RowVersion];
							if (result[TABLE.BloodUnitTest.TestComments].ToString().Length>0)
							{
								dr[ARTIFICIAL.Comment] = result[TABLE.BloodUnitTest.TestComments];
							}
							if (dr[ARTIFICIAL.DCC].ToString().Length>0)
							{
								dr[ARTIFICIAL.DCCSave] = false;
							}
						}
						else if (bloodTestType.IndexOf("D Control CC") > -1)
						{
							dr[ARTIFICIAL.DcCC] = result[TABLE.BloodUnitTest.TestResultId].ToString().Trim();
							dr[ARTIFICIAL.DcCCGuid] = result[TABLE.BloodUnitTest.BloodUnitTestGuid];
							dr[ARTIFICIAL.DcCCRowVersion] = result[TABLE.BloodUnitTest.RowVersion];
							if (result[TABLE.BloodUnitTest.TestComments].ToString().Length>0)
							{
								dr[ARTIFICIAL.Comment] = result[TABLE.BloodUnitTest.TestComments];
							}
							if (dr[ARTIFICIAL.DcCC].ToString().Length>0)
							{
								dr[ARTIFICIAL.DcCCSave] = false;
							}
						}
						else if (bloodTestType.IndexOf(ARTIFICIAL.Interp) > -1)
						{
							dr[ARTIFICIAL.Interp] = result[TABLE.BloodUnitTest.TestResultId].ToString().Trim();
							dr[ARTIFICIAL.InterpGuid] = result[TABLE.BloodUnitTest.BloodUnitTestGuid];
							dr[ARTIFICIAL.InterpRowVersion] = result[TABLE.BloodUnitTest.RowVersion];
							if (result[TABLE.BloodUnitTest.TestComments].ToString().Length>0)
							{
								dr[ARTIFICIAL.Comment] = result[TABLE.BloodUnitTest.TestComments];
							}
							if (dr[ARTIFICIAL.Interp].ToString().Length>0)
							{
								dr[ARTIFICIAL.InterpSave] = false;
							}
						}
					}
				}
				//
				dt.Rows.Add(dr);
			}
			//
			return dt;
		}


		#endregion

		#region Set Data Source

		/// <summary>
		/// SetPhenotypeDataSource
		/// </summary>
		public void SetPhenotypeDataSource()
		{
			this.dgPhenotype.DataSource = null;
			this.dgPhenotype.Visible = false;
		}

		/// <summary>
		/// SetPhenotypeDataSource
		/// </summary>
		/// <param name="dtPhenotype"></param>
		public void SetPhenotypeDataSource(DataTable dtPhenotype)
		{
			this.dgPhenotype.DataSource = dtPhenotype.DefaultView;
			this.dgPhenotype.ProcessAcross = false;
			((DataView)dgPhenotype.DataSource).AllowNew = false;
			((DataView)dgPhenotype.DataSource).AllowDelete = false;
			//
			if (dtPhenotype.Rows.Count > 0)
			{
				this._dataTablePhenotype = dtPhenotype;
				foreach (DataRow dr in this._dataTablePhenotype.Rows)
				{
					this._drPhenotype = dr;
					UpdatePhenotypeIndicator();
				}
			}
			this.dgPhenotype.Visible = true;
			//
			this._dtComments = BOL.CannedComment.GetCannedComments(Common.LogonUser.LogonUserDivisionCode,"UT");
			cmbComment.Items.Clear();
			foreach(DataRow drComment in _dtComments.Rows)
			{
				cmbComment.Items.Add(drComment[TABLE.CannedComment.CannedCommentText].ToString());
			}
			cmbComment.LookupEnabled = false;
		}

		/// <summary>
		/// SetControlDataSource
		/// </summary>
		public void SetControlDataSource()
		{
			this.dgControl.DataSource = null;
			this.dgControl.Visible = false;
			this.dgControl.Enabled = false;
		}

		/// <summary>
		/// SetControlDataSource
		/// </summary>
		/// <param name="dtControl"></param>
		public void SetControlDataSource(DataTable dtControl)
		{
			this.dgControl.DataSource = dtControl.DefaultView;
			this.dgControl.ProcessAcross = false;
			((DataView)dgControl.DataSource).AllowNew = false;
			((DataView)dgControl.DataSource).AllowDelete = false;
			//
			if (dtControl.Rows.Count > 0)
			{
				this.dgControl.Enabled = true;
				//
				this._dataTableControl = dtControl;
				this._drControl = this._dataTableControl.Rows[0];
				UpdateControlIndicator(true);
				this._drControl = this._dataTableControl.Rows[1];
				UpdateControlIndicator(false);
				this._dtComments = BOL.CannedComment.GetCannedComments(Common.LogonUser.LogonUserDivisionCode,"UT");
				cmbControlComment.Items.Clear();
				foreach(DataRow drComment in _dtComments.Rows)
				{
					cmbControlComment.Items.Add(drComment[TABLE.CannedComment.CannedCommentText].ToString());
				}
				cmbControlComment.LookupEnabled = false;
			}
			this.dgControl.Visible = true;
			//
			this._dtReagentTypes = BOL.ReagentType.GetAntigenTypingQCReagentTypes();
			//
		}

		/// <summary>
		/// SetWeakDDataSource
		/// </summary>
		public void SetWeakDDataSource()
		{
			this.dgWeakD.DataSource = null;
			this.dgWeakD.Visible = false;
		}

		/// <summary>
		/// SetWeakDDataSource
		/// </summary>
		/// <param name="dtWeakD"></param>
		public void SetWeakDDataSource(DataTable dtWeakD)
		{
			this.dgWeakD.DataSource = dtWeakD.DefaultView;
			this.dgWeakD.ProcessAcross = false;
			((DataView)dgWeakD.DataSource).AllowNew = false;
			((DataView)dgWeakD.DataSource).AllowDelete = false;
			//
			if (dtWeakD.Rows.Count > 0)
			{
				this._dataTableWeakD = dtWeakD;
				foreach (DataRow dr in this._dataTableWeakD.Rows)
				{
					this._drWeakD = dr;
					UpdateWeakDIndicator();
				}
			}
			this.dgWeakD.Visible = true;
			//
			this._dtComments = BOL.CannedComment.GetCannedComments(Common.LogonUser.LogonUserDivisionCode,"UT");
			cmbWeakDComment.Items.Clear();
			foreach(DataRow drComment in _dtComments.Rows)
			{
				cmbWeakDComment.Items.Add(drComment[TABLE.CannedComment.CannedCommentText].ToString());
			}
			cmbWeakDComment.LookupEnabled = false;
		}

		#endregion

		#region Create Table Schema
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// Creates the blood unit test data table. 
		/// </summary>
		private DataTable CreateControlTestTable()
		{
			DataTable dt = new System.Data.DataTable(ARTIFICIAL.Control);
			dt.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dt.Columns.Add(ARTIFICIAL.Control, typeof(string));
			dt.Columns.Add(ARTIFICIAL.ReagentType,typeof(string));
			dt.Columns.Add(TABLE.Reagent.LotNumber, typeof(string));
			dt.Columns.Add(ARTIFICIAL.VialId, typeof(string));
			dt.Columns.Add(ARTIFICIAL.IS,typeof(string));
			dt.Columns.Add(ARTIFICIAL.RT,typeof(string));
			dt.Columns.Add(ARTIFICIAL.C37,typeof(string));
			dt.Columns.Add(ARTIFICIAL.AHG,typeof(string));
			dt.Columns.Add(ARTIFICIAL.CC, typeof(string));
			dt.Columns.Add(ARTIFICIAL.ControlInterp, typeof(string));			
			dt.Columns.Add(ARTIFICIAL.ControlComment, typeof(string));
			dt.Columns.Add(ARTIFICIAL.SystemControlInterp, typeof(string));
			dt.Columns.Add(TABLE.Reagent.ReagentGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.ControlReagentGuid, typeof(Guid));
			dt.Columns.Add(TABLE.Reagent.ReagentManufacturerName, typeof(string));
			dt.Columns.Add(TABLE.Reagent.LotExpirationDate, typeof(DateTime));
			dt.Columns.Add(TABLE.ReactivityPhase.ReactivityPhaseCode, typeof(string));
			dt.Columns.Add(ARTIFICIAL.IndicatorMessage, typeof(string));
			dt.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.ISGuid,typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.RTGuid,typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.C37Guid,typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.AHGGuid,typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.ControlInterpGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.ISRowVersion,typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.RTRowVersion,typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.C37RowVersion,typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.AHGRowVersion,typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.CCRowVersion,typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.InterpRowVersion,typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.ISSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.RTSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.C37Save, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.ControlInterpSave, typeof(bool));
			dt.Columns.Add(TABLE.VamcDivision.DivisionCode, typeof(string));
			dt.Columns.Add(TABLE.ReagentTestParameter.TestWithId, typeof(int));
			dt.Columns.Add(ARTIFICIAL.OverrideComment, typeof(string));
			//
			return dt;
		}
		
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// Creates the blood unit test data table. 
		/// </summary>
		public DataTable CreatePhenotypeTestTable()
		{
			DataTable dt = new System.Data.DataTable("Phenotype");
			//
			dt.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dt.Columns.Add(TABLE.ExceptionAntigenTest.UnitId, typeof(string));
			dt.Columns.Add(TABLE.BloodProduct.ProductName, typeof(string));
			dt.Columns.Add(ARTIFICIAL.IS,typeof(string));
			dt.Columns.Add(ARTIFICIAL.RT,typeof(string));
			dt.Columns.Add(ARTIFICIAL.C37,typeof(string));
			dt.Columns.Add(ARTIFICIAL.AHG,typeof(string));
			dt.Columns.Add(ARTIFICIAL.CC, typeof(string));
			dt.Columns.Add(ARTIFICIAL.Interp, typeof(string));			
			dt.Columns.Add(ARTIFICIAL.Comment, typeof(string));
			dt.Columns.Add(TABLE.ValidRhResult.SystemInterp, typeof(string));
			dt.Columns.Add(TABLE.BloodUnit.BloodUnitGuid, typeof(Guid));
			dt.Columns.Add(TABLE.Reagent.ReagentGuid, typeof(Guid));
			dt.Columns.Add(TABLE.ReactivityPhase.ReactivityPhaseCode, typeof(string));
			dt.Columns.Add(TABLE.OrderableTest.OrderableTestId,typeof(string));
			dt.Columns.Add(ARTIFICIAL.IndicatorMessage, typeof(string));
			dt.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.ISGuid,typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.RTGuid,typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.C37Guid,typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.AHGGuid,typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.InterpGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.ISRowVersion,typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.RTRowVersion,typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.C37RowVersion,typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.AHGRowVersion,typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.CCRowVersion,typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.InterpRowVersion,typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.ISSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.RTSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.C37Save, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.InterpSave, typeof(bool));
			dt.Columns.Add(TABLE.BloodUnitStatus.QuarantineIndicator, typeof(bool));
			dt.Columns.Add(TABLE.VamcDivision.DivisionCode, typeof(string));
			dt.Columns.Add(TABLE.ExceptionQc.ExceptionComment, typeof(string));
			//
			return dt;
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// Creates the blood unit test data table. 
		/// </summary>
		public DataTable CreateWeakDTestTable()
		{
			DataTable dt = new System.Data.DataTable("WeakD");
			//
			dt.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dt.Columns.Add(TABLE.ExceptionAntigenTest.UnitId, typeof(string));
			dt.Columns.Add(TABLE.BloodProduct.ProductName, typeof(string));
			dt.Columns.Add(ARTIFICIAL.D37,typeof(string));
			dt.Columns.Add(ARTIFICIAL.Dc37,typeof(string));
			dt.Columns.Add(ARTIFICIAL.DAHG,typeof(string));
			dt.Columns.Add(ARTIFICIAL.DcAHG,typeof(string));
			dt.Columns.Add(ARTIFICIAL.DCC, typeof(string));
			dt.Columns.Add(ARTIFICIAL.DcCC, typeof(string));
			dt.Columns.Add(ARTIFICIAL.Interp, typeof(string));			
			dt.Columns.Add(ARTIFICIAL.Comment, typeof(string));
			dt.Columns.Add(TABLE.ValidRhResult.SystemInterp, typeof(string));
			dt.Columns.Add(TABLE.BloodUnit.BloodUnitGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.AntiDReagentGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.DControlReagentGuid, typeof(Guid));
			dt.Columns.Add(TABLE.ReactivityPhase.ReactivityPhaseCode, typeof(string));
			dt.Columns.Add(TABLE.OrderableTest.OrderableTestId,typeof(string));
			dt.Columns.Add(ARTIFICIAL.IndicatorMessage, typeof(string));
			dt.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.D37Guid,typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.Dc37Guid,typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.DAHGGuid,typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.DcAHGGuid,typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.DCCGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.DcCCGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.InterpGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.D37RowVersion,typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.Dc37RowVersion,typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.DAHGRowVersion,typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.DcAHGRowVersion,typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.DCCRowVersion,typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.DcCCRowVersion,typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.InterpRowVersion,typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.D37Save, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.Dc37Save, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.DAHGSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.DcAHGSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.DCCSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.DcCCSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.InterpSave, typeof(bool));
			dt.Columns.Add(TABLE.BloodUnitStatus.QuarantineIndicator, typeof(bool));
			dt.Columns.Add(TABLE.VamcDivision.DivisionCode, typeof(string));
			dt.Columns.Add(TABLE.Rack.RackGuid, typeof(Guid));
			dt.Columns.Add(TABLE.ExceptionQc.ExceptionComment, typeof(string));
			//
			return dt;
		}

		#endregion

		#region TableStyles

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// Adds the custom data table style to the data grid.
		/// Implements BR_2.22, BR_2.23, BR_41.17
		/// </summary>
		private void AddControlCustomDataTableStyle()
		{
			_dgControlTableStyle = new DataGridTableStyle();
			_dgControlTableStyle.PreferredRowHeight = 22;

			//BR_2.23
			_dgControlTableStyle.AllowSorting = false;
			_dgControlTableStyle.DataGrid = this.dgControl;

			_dgControlTableStyle.HeaderFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)), true);
			_dgControlTableStyle.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			_dgControlTableStyle.MappingName = ARTIFICIAL.Control;
			_dgControlTableStyle.RowHeadersVisible = false;
			// 
			// Indicator
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.Indicator;
			_dcTextKeyTrapCol.ReadOnly = true;
			_dcTextKeyTrapCol.Width = 20;
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			// 
			// Control
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.HeaderText = ARTIFICIAL.Control;
			_dcTextBox.MappingName = ARTIFICIAL.Control;
			//BR_2.22
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 50;
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// ReagentType
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.HeaderText = "Reagent";
			_dcTextBox.MappingName = ARTIFICIAL.ReagentType;
			_dcTextBox.ReadOnly = false;
			_dcTextBox.Width = 105;
			_dcTextBox.TextBox.Controls.Add(cmbReagentType);
			cmbReagentType.BringToFront();
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// LotNumber
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.HeaderText = "Lot Number";
			_dcTextBox.MappingName = TABLE.Reagent.LotNumber;
			_dcTextBox.ReadOnly = false;
			_dcTextBox.Width = 95;
			_dcTextBox.TextBox.Controls.Add(cmbLotNumber);
			cmbLotNumber.BringToFront();
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// VialID
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Left;
			_dcTextKeyTrapCol.HeaderText = "Vial";
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.VialId;
			_dcTextKeyTrapCol.Width = 30;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(ControlTextBoxKeyPress);
			//CR 2792
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(ControlTextBox_TextChanged);
			// 
			// IS
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			//BR_41.17
			_dcTextKeyTrapCol.HeaderText = ARTIFICIAL.IS;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.IS;
			_dcTextKeyTrapCol.Width = 35;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(ControlTextBoxKeyPress);
			//CR 2792
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(ControlTextBox_TextChanged);
			// 
			// RT
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			//BR_41.17
			_dcTextKeyTrapCol.HeaderText = ARTIFICIAL.RT;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.RT;
			_dcTextKeyTrapCol.Width = 35;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(ControlTextBoxKeyPress);
			//CR 2792
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(ControlTextBox_TextChanged);
			// 
			// 37
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			//BR_41.17
			_dcTextKeyTrapCol.HeaderText = ARTIFICIAL.C37;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.C37;
			_dcTextKeyTrapCol.Width = 35;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(ControlTextBoxKeyPress);
			//CR 2792
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(ControlTextBox_TextChanged);
			// 
			// AHG
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			//BR_41.17
			_dcTextKeyTrapCol.HeaderText = ARTIFICIAL.AHG;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.AHG;
			_dcTextKeyTrapCol.Width = 35;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(ControlTextBoxKeyPress);
			//CR 2792
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(ControlTextBox_TextChanged);
			// 
			// CC
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			//BR_41.17
			_dcTextKeyTrapCol.HeaderText = ARTIFICIAL.CC;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.CC;
			_dcTextKeyTrapCol.Width = 35;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(ControlTextBoxKeyPress);
			//CR 2792
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(ControlTextBox_TextChanged);
			// 
			// ControlInterp
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = "Interp.";
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.ControlInterp;
			_dcTextKeyTrapCol.Width = 50;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(ControlTextBoxKeyPress);
			//CR 2792
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(ControlTextBox_TextChanged);
			// 
			// ControlComment
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.HeaderText = ARTIFICIAL.Comment;
			_dcTextBox.MappingName = ARTIFICIAL.ControlComment;
			_dcTextBox.Width = 98;
			_dcTextBox.TextBox.Controls.Add(cmbControlComment);
			cmbControlComment.BringToFront();
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// ControlSystemInterp
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = "ControlSystemInterp";
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// ReagentGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.Reagent.ReagentGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// ControlReagentGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.ControlReagentGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// ReagentManufacturerName
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.Reagent.ReagentManufacturerName;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// LotExpirationDate
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.Reagent.LotExpirationDate;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// ReactivityPhaseCode
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.ReactivityPhase.ReactivityPhaseCode;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// IndicatorMessage
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.IndicatorMessage;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// PartiallyCompleted
			//
			_dcCheckBox = new DataGridBoolColumn();
			_dcCheckBox.MappingName = ARTIFICIAL.PartiallyCompleted;
			_dcCheckBox.ReadOnly = true;
			_dcCheckBox.Width = 0;
			_dgControlTableStyle.GridColumnStyles.Add(_dcCheckBox);
			//
			// ISGuid
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.ISGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// RTGuid
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.RTGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// 37Guid
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.C37Guid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// AHGGuid
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AHGGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// CCGuid
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.CCGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// ControlInterpGuid
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.ControlInterpGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// ISRowVersion
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.ISRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// RTRowVersion
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.RTRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// 37RowVersion
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.C37RowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// AHGRowVersion
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AHGRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// CCRowVersion
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.CCRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// InterpRowVersion
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.InterpRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// ISSave
			//
			_dcCheckBox = new DataGridBoolColumn();
			_dcCheckBox.MappingName = ARTIFICIAL.ISSave;
			_dcCheckBox.ReadOnly = true;
			_dcCheckBox.Width = 0;
			_dgControlTableStyle.GridColumnStyles.Add(_dcCheckBox);
			//
			// RTSave
			//
			_dcCheckBox = new DataGridBoolColumn();
			_dcCheckBox.MappingName = ARTIFICIAL.RTSave;
			_dcCheckBox.ReadOnly = true;
			_dcCheckBox.Width = 0;
			_dgControlTableStyle.GridColumnStyles.Add(_dcCheckBox);
			//
			// 37Save
			//
			_dcCheckBox = new DataGridBoolColumn();
			_dcCheckBox.MappingName = ARTIFICIAL.C37Save;
			_dcCheckBox.ReadOnly = true;
			_dcCheckBox.Width = 0;
			_dgControlTableStyle.GridColumnStyles.Add(_dcCheckBox);
			//
			// AHGSave
			//
			_dcCheckBox = new DataGridBoolColumn();
			_dcCheckBox.MappingName = ARTIFICIAL.AHGSave;
			_dcCheckBox.ReadOnly = true;
			_dcCheckBox.Width = 0;
			_dgControlTableStyle.GridColumnStyles.Add(_dcCheckBox);
			//
			// CCSave
			//
			_dcCheckBox = new DataGridBoolColumn();
			_dcCheckBox.MappingName = ARTIFICIAL.CCSave;
			_dcCheckBox.ReadOnly = true;
			_dcCheckBox.Width = 0;
			_dgControlTableStyle.GridColumnStyles.Add(_dcCheckBox);
			//
			// ControlInterpSave
			//
			_dcCheckBox = new DataGridBoolColumn();
			_dcCheckBox.MappingName = ARTIFICIAL.ControlInterpSave;
			_dcCheckBox.ReadOnly = true;
			_dcCheckBox.Width = 0;
			_dgControlTableStyle.GridColumnStyles.Add(_dcCheckBox);
			//
			// QCLotNumbersSave
			//
			_dcCheckBox = new DataGridBoolColumn();
			_dcCheckBox.MappingName = "QCLotNumberSave";
			_dcCheckBox.ReadOnly = true;
			_dcCheckBox.Width = 0;
			_dgControlTableStyle.GridColumnStyles.Add(_dcCheckBox);
			// 
			// DivisionCode
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.VamcDivision.DivisionCode;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// TestWithId
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.ReagentTestParameter.TestWithId;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// OverrideComment
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.OverrideComment;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgControlTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			dgControl.TableStyles.Add(_dgControlTableStyle);				
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// Adds the custom data table style to the data grid.
		/// Implements BR_2.22, BR_2.23, BR_41.17, BR_41.18
		/// </summary>
		private void AddPhenotypeCustomDataTableStyle()//DataRow drRackLot)
		{
			_dgPhenotypeTableStyle = new DataGridTableStyle();
			_dgPhenotypeTableStyle.PreferredRowHeight = 22;

			//BR_2.23
			_dgPhenotypeTableStyle.AllowSorting = false;
			_dgPhenotypeTableStyle.DataGrid = this.dgPhenotype;

			_dgPhenotypeTableStyle.HeaderFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)), true);
			_dgPhenotypeTableStyle.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			_dgPhenotypeTableStyle.MappingName = "Phenotype";
			_dgPhenotypeTableStyle.RowHeadersVisible = false;
			// 
			// Indicator
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.Indicator;
			_dcTextKeyTrapCol.ReadOnly = true;
			_dcTextKeyTrapCol.Width = 20;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			// 
			// UnitId
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.HeaderText = "Unit ID";
			_dcTextBox.MappingName = TABLE.ExceptionAntigenTest.UnitId;
			//BR_2.22, BR_41.18
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 120;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// ProductName
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.HeaderText = "Product Name";
			_dcTextBox.MappingName = TABLE.BloodProduct.ProductName;
			//BR_2.22
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 160;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// IS
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			//BR_41.17
			_dcTextKeyTrapCol.HeaderText = ARTIFICIAL.IS;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.IS;
			_dcTextKeyTrapCol.Width = 35;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(PhenotypeTextBoxKeyPress);
			//CR 2792
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(PhenotypeTextBox_TextChanged);
			// 
			// RT
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			//BR_41.17
			_dcTextKeyTrapCol.HeaderText = ARTIFICIAL.RT;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.RT;
			_dcTextKeyTrapCol.Width = 35;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(PhenotypeTextBoxKeyPress);
			//CR 2792
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(PhenotypeTextBox_TextChanged);
			// 
			// 37
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			//BR_41.17
			_dcTextKeyTrapCol.HeaderText = ARTIFICIAL.C37;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.C37;
			_dcTextKeyTrapCol.Width = 35;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(PhenotypeTextBoxKeyPress);
			//CR 2792
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(PhenotypeTextBox_TextChanged);
			// 
			// AHG
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			//BR_41.17
			_dcTextKeyTrapCol.HeaderText = ARTIFICIAL.AHG;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.AHG;
			_dcTextKeyTrapCol.Width = 35;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(PhenotypeTextBoxKeyPress);
			//CR 2792
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(PhenotypeTextBox_TextChanged);
			// 
			// CC
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			//BR_41.17
			_dcTextKeyTrapCol.HeaderText = ARTIFICIAL.CC;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.CC;
			_dcTextKeyTrapCol.Width = 35;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(PhenotypeTextBoxKeyPress);
			//CR 2792
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(PhenotypeTextBox_TextChanged);
			// 
			// Interp
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = "Interp.";
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.Interp;
			_dcTextKeyTrapCol.Width = 50;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(PhenotypeTextBoxKeyPress);
			//CR 2792
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(PhenotypeTextBox_TextChanged);
			// 
			// Comment
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.HeaderText = ARTIFICIAL.Comment;
			_dcTextBox.MappingName = ARTIFICIAL.Comment;
			_dcTextBox.Width = 98;
			_dcTextBox.TextBox.Controls.Add(cmbComment);
			cmbComment.BringToFront();
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// SystemInterp
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.ValidRhResult.SystemInterp;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// BloodUnitGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.BloodUnit.BloodUnitGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// ReagentGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.Reagent.ReagentGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// ReactivityPhaseCode
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.ReactivityPhase.ReactivityPhaseCode;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// OrderableTestId
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.OrderableTest.OrderableTestId;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// IndicatorMessage
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.IndicatorMessage;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// PartiallyCompleted
			//
			_dcCheckBox = new DataGridBoolColumn();
			_dcCheckBox.MappingName = ARTIFICIAL.PartiallyCompleted;
			_dcCheckBox.ReadOnly = true;
			_dcCheckBox.Width = 0;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcCheckBox);
			//
			// ISGuid
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.ISGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// RTGuid
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.RTGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// 37Guid
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.C37Guid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// AHGGuid
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AHGGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// CCGuid
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.CCGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// InterpGuid
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.InterpGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// ISRowVersion
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.ISRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// RTRowVersion
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.RTRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// 37RowVersion
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.C37RowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// AHGRowVersion
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AHGRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// CCRowVersion
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.CCRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// InterpRowVersion
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.InterpRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			//
			// ISSave
			//
			_dcCheckBox = new DataGridBoolColumn();
			_dcCheckBox.MappingName = ARTIFICIAL.ISSave;
			_dcCheckBox.ReadOnly = true;
			_dcCheckBox.Width = 0;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcCheckBox);
			//
			// RTSave
			//
			_dcCheckBox = new DataGridBoolColumn();
			_dcCheckBox.MappingName = ARTIFICIAL.RTSave;
			_dcCheckBox.ReadOnly = true;
			_dcCheckBox.Width = 0;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcCheckBox);
			//
			// 37Save
			//
			_dcCheckBox = new DataGridBoolColumn();
			_dcCheckBox.MappingName = ARTIFICIAL.C37Save;
			_dcCheckBox.ReadOnly = true;
			_dcCheckBox.Width = 0;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcCheckBox);
			//
			// AHGSave
			//
			_dcCheckBox = new DataGridBoolColumn();
			_dcCheckBox.MappingName = ARTIFICIAL.AHGSave;
			_dcCheckBox.ReadOnly = true;
			_dcCheckBox.Width = 0;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcCheckBox);
			//
			// CCSave
			//
			_dcCheckBox = new DataGridBoolColumn();
			_dcCheckBox.MappingName = ARTIFICIAL.CCSave;
			_dcCheckBox.ReadOnly = true;
			_dcCheckBox.Width = 0;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcCheckBox);
			//
			// InterpSave
			//
			_dcCheckBox = new DataGridBoolColumn();
			_dcCheckBox.MappingName = ARTIFICIAL.InterpSave;
			_dcCheckBox.ReadOnly = true;
			_dcCheckBox.Width = 0;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcCheckBox);
			//
			// QuarantineIndicator
			//
			_dcCheckBox = new DataGridBoolColumn();
			_dcCheckBox.MappingName = TABLE.BloodUnitStatus.QuarantineIndicator;
			_dcCheckBox.ReadOnly = true;
			_dcCheckBox.Width = 0;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcCheckBox);
			// 
			// DivisionCode
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.VamcDivision.DivisionCode;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// ExceptionComment
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.ExceptionQc.ExceptionComment;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPhenotypeTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			dgPhenotype.TableStyles.Add(_dgPhenotypeTableStyle);
							
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// Adds the custom data table style to the data grid.
		/// Implements BR_2.22, BR_2.23, BR_41.17, BR_41.18
		/// </summary>
		private void AddWeakDCustomDataTableStyle()
		{
			_dgWeakDTableStyle = new DataGridTableStyle();
			_dgWeakDTableStyle.PreferredRowHeight = 22;

			//BR_2.23
			_dgWeakDTableStyle.AllowSorting = false;
			_dgWeakDTableStyle.DataGrid = this.dgWeakD;

			_dgWeakDTableStyle.HeaderFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)), true);
			_dgWeakDTableStyle.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			_dgWeakDTableStyle.MappingName = "WeakD";
			_dgWeakDTableStyle.RowHeadersVisible = false;
			// 
			// Indicator
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.Indicator;
			_dcTextKeyTrapCol.ReadOnly = true;
			_dcTextKeyTrapCol.Width = 20;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			// 
			// UnitId
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.HeaderText = "Unit ID";
			_dcTextBox.MappingName = TABLE.ExceptionAntigenTest.UnitId;
			//BR_2.22, BR_41.18
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 100;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// ProductName
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.HeaderText = "Product Name";
			_dcTextBox.MappingName = TABLE.BloodProduct.ProductName;
			//BR_2.22
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 100;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// D37
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			//BR_41.17
			_dcTextKeyTrapCol.HeaderText = "D 37";
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.D37;
			_dcTextKeyTrapCol.Width = 35;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(WeakDTextBoxKeyPress);
			//CR 2792
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(WeakDTextBox_TextChanged);
			// 
			// Dc37
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			//BR_41.17
			_dcTextKeyTrapCol.HeaderText = "Dc 37";
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.Dc37;
			_dcTextKeyTrapCol.Width = 40;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(WeakDTextBoxKeyPress);
			//CR 2792
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(WeakDTextBox_TextChanged);
			// 
			// DAHG
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			//BR_41.17
			_dcTextKeyTrapCol.HeaderText = "D AHG";
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.DAHG;
			_dcTextKeyTrapCol.Width = 40;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(WeakDTextBoxKeyPress);
			//CR 2792
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(WeakDTextBox_TextChanged);
			// 
			// DcAHG
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			//BR_41.17
			_dcTextKeyTrapCol.HeaderText = "Dc AHG";
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.DcAHG;
			_dcTextKeyTrapCol.Width = 50;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(WeakDTextBoxKeyPress);
			//CR 2792
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(WeakDTextBox_TextChanged);
			// 
			// DCC
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			//BR_41.17
			_dcTextKeyTrapCol.HeaderText = "D CC";
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.DCC;
			_dcTextKeyTrapCol.Width = 35;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(WeakDTextBoxKeyPress);
			//CR 2792
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(WeakDTextBox_TextChanged);
			// 
			// DcCC
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			//BR_41.17
			_dcTextKeyTrapCol.HeaderText = "Dc CC";
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.DcCC;
			_dcTextKeyTrapCol.Width = 40;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(WeakDTextBoxKeyPress);
			//CR 2792
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(WeakDTextBox_TextChanged);
			// 
			// Interp
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = "Interp.";
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.Interp;
			_dcTextKeyTrapCol.Width = 50;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(WeakDTextBoxKeyPress);
			//CR 2792
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(WeakDTextBox_TextChanged);
			// 
			// Comment
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.HeaderText = ARTIFICIAL.Comment;
			_dcTextBox.MappingName = ARTIFICIAL.Comment;
			_dcTextBox.Width = 110;
			_dcTextBox.TextBox.Controls.Add(cmbWeakDComment);
			cmbWeakDComment.BringToFront();
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// SystemInterp
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.ValidRhResult.SystemInterp;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// BloodUnitGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.BloodUnit.BloodUnitGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// AntiDReagentGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AntiDReagentGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// DControlReagentGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.DControlReagentGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// ReactivityPhaseCode
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.ReactivityPhase.ReactivityPhaseCode;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// OrderableTestId
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.OrderableTest.OrderableTestId;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// IndicatorMessage
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.IndicatorMessage;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// PartiallyCompleted
			//
			_dcCheckBox = new DataGridBoolColumn();
			_dcCheckBox.MappingName = ARTIFICIAL.PartiallyCompleted;
			_dcCheckBox.ReadOnly = true;
			_dcCheckBox.Width = 0;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcCheckBox);
			//
			// D37Guid
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.D37Guid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// Dc37Guid
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.Dc37Guid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// DAHGGuid
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.DAHGGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// DcAHGGuid
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.DcAHGGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// DCCGuid
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.DCCGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// DcCCGuid
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.DcCCGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// InterpGuid
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.InterpGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// D37RowVersion
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.D37RowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// Dc37RowVersion
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.Dc37RowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// DAHGRowVersion
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.DAHGRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// DcAHGRowVersion
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.DcAHGRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// DCCRowVersion
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.DCCRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// DcCCRowVersion
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.DcCCRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			// InterpRowVersion
			//
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.InterpRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			//
			// D37Save
			//
			_dcCheckBox = new DataGridBoolColumn();
			_dcCheckBox.MappingName = ARTIFICIAL.D37Save;
			_dcCheckBox.ReadOnly = true;
			_dcCheckBox.Width = 0;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcCheckBox);
			//
			// Dc37Save
			//
			_dcCheckBox = new DataGridBoolColumn();
			_dcCheckBox.MappingName = ARTIFICIAL.Dc37Save;
			_dcCheckBox.ReadOnly = true;
			_dcCheckBox.Width = 0;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcCheckBox);
			//
			// DAHGSave
			//
			_dcCheckBox = new DataGridBoolColumn();
			_dcCheckBox.MappingName = ARTIFICIAL.DAHGSave;
			_dcCheckBox.ReadOnly = true;
			_dcCheckBox.Width = 0;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcCheckBox);
			//
			// DcAHGSave
			//
			_dcCheckBox = new DataGridBoolColumn();
			_dcCheckBox.MappingName = ARTIFICIAL.DcAHGSave;
			_dcCheckBox.ReadOnly = true;
			_dcCheckBox.Width = 0;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcCheckBox);
			//
			// DCCSave
			//
			_dcCheckBox = new DataGridBoolColumn();
			_dcCheckBox.MappingName = ARTIFICIAL.DCCSave;
			_dcCheckBox.ReadOnly = true;
			_dcCheckBox.Width = 0;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcCheckBox);
			//
			// DcCCSave
			//
			_dcCheckBox = new DataGridBoolColumn();
			_dcCheckBox.MappingName = ARTIFICIAL.DcCCSave;
			_dcCheckBox.ReadOnly = true;
			_dcCheckBox.Width = 0;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcCheckBox);
			//
			// InterpSave
			//
			_dcCheckBox = new DataGridBoolColumn();
			_dcCheckBox.MappingName = ARTIFICIAL.InterpSave;
			_dcCheckBox.ReadOnly = true;
			_dcCheckBox.Width = 0;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcCheckBox);
			//
			// QuarantineIndicator
			//
			_dcCheckBox = new DataGridBoolColumn();
			_dcCheckBox.MappingName = TABLE.BloodUnitStatus.QuarantineIndicator;
			_dcCheckBox.ReadOnly = true;
			_dcCheckBox.Width = 0;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcCheckBox);
			// 
			// DivisionCode
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.VamcDivision.DivisionCode;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// RackGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.Rack.RackGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// ExceptionComment
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.ExceptionQc.ExceptionComment;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgWeakDTableStyle.GridColumnStyles.Add(_dcTextBox);
			//
			dgWeakD.TableStyles.Add(_dgWeakDTableStyle);
							
		}

		#endregion

		#region Key Press Event Handlers

		/// <summary>
		/// Unit Antigen Typing QC Grid Key Press Event Handler
		/// Implements BR_2.28
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void ControlTextBoxKeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			try
			{
				int row = this.dgControl.CurrentCell.RowNumber;
				int column = this.dgControl.CurrentCell.ColumnNumber;
				string cellText = string.Empty;
				string cellTextFuture = string.Empty;
				string KeyChar = string.Empty;
				string regPattern = string.Empty;
				bool findNextCell = false;
			
				TextBox c = (TextBox) sender;

				cellText = c.Text;
			
				// Let backspace and enter keys bypass
				if ((e.KeyChar == (int)Keys.Back) || (e.KeyChar == (int)Keys.Enter))
				{
					if (e.KeyChar == (int)Keys.Back)
					{
						DataTable dt = ((DataView)this.dgControl.DataSource).Table;
						dt.Rows[row][column] = string.Empty;
						UpdateControlIndicator((row==0));
					}
					e.Handled = !char.IsControl(e.KeyChar);
					return;
				}
			
				// Turn single character to upper
				KeyChar = e.KeyChar.ToString().ToUpper()[0].ToString();

				// Obtain what the string will look like after key is pressed
				if (cellText.Length > 0)
				{
					cellTextFuture = cellText.Substring(0, c.SelectionStart) + KeyChar + cellText.Substring(c.SelectionStart + c.SelectionLength, cellText.Length - (c.SelectionLength + c.SelectionStart));
				}
				else
				{
					cellTextFuture = KeyChar;
				}

				// Test what type of column it is and then apply the regular expression
				if (column == 4) //Vial ID
				{
					regPattern = @"(^[0-9]{1,2})$";
					findNextCell = false;
				}

				if (column == 10)  // ControlInterp
				{
					//CR 2653 removed I from the list of possible interpretations
					regPattern = @"(\A[PN]\z)";
					findNextCell = true;
				}
				else if (column == 5 || column == 6 ||				// IS	RT
					column == 7 || column == 8 || column == 9)		// 37	AHG		CC
				{
					regPattern = @"(\A[WFMR01234X]\z)";
					findNextCell = true;
				}
				//
				if (Regex.IsMatch(cellTextFuture, regPattern))
				{
					//changing values in the datable causes TextChanged event to be fired
					//setting a flag to prevent it from happening CR 2792
					this._keyPressEventHandledPheno = true;
					
					c.Text = cellTextFuture;
					c.SelectionStart = c.SelectionLength + 1;
					//
					DataTable dt = ((DataView)this.dgControl.DataSource).Table;
					dt.Rows[row][column] = c.Text;
					UpdateControlIndicator((row==0));
					//
					if (findNextCell)
					{
						this.dgControl.Direction = GridDirection.Down;
						this.dgControl.FindNextCell();
					}
					this._keyPressEventHandledPheno = false;
				}
				else
				{
					//BR_2.28
					GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.Common.InvalidKeyPressed());
				}
				//
				e.Handled = true;
				return;			
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		/// <summary>
		/// This method handles entering invalid entries into the grid (CR 2792)
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void ControlTextBox_TextChanged(object sender, EventArgs e)
		{
			if (this._keyPressEventHandledPheno || this.dgControl.EnterKeyPressed == true || this.dgPhenotype.EnterKeyPressed == true)
			{
				return;
			}
			else
			{
				int row = this.dgControl.CurrentCell.RowNumber;
				int column = this.dgControl.CurrentCell.ColumnNumber;
				DataTable dt = ((DataView)this.dgControl.DataSource).Table;
			
				//forcing the validation of the grid
				if (sender is System.Windows.Forms.DataGridTextBox)
				{
					//if the grid cell has anything in it run the regex match
					if (((DataGridTextBox)sender).Text != "" && ((DataGridTextBox)sender).Text != "(null)")
					{
						string regPattern = "";

						// Test what type of column it is and then apply the regular expression
						if (column == 4) //Vial ID
						{
							regPattern = @"(^[0-9]{1,2})$";
						}

						if (column == 10)  // ControlInterp
						{
							//CR 2653 removed I from the list of possible interpretations
							regPattern = @"(\A[PN]\z)";
						}
						else if (column == 5 || column == 6 ||				// IS	RT
							column == 7 || column == 8 || column == 9)		// 37	AHG		CC
						{
							regPattern = @"(\A[WFMR01234X]\z)";
						}

						if (Regex.IsMatch(((DataGridTextBox)sender).Text, regPattern))
						{
							//changing values in the datable causes TextChanged event to be fired
							//setting a flag to prevent it from happening
							this._keyPressEventHandledPheno = true;
							dt.Rows[row][column] = ((DataGridTextBox)sender).Text;
							
							UpdateControlIndicator((row==0));
							this.dgControl.Refresh();
							onCurrentCellChanged(this.dgControl, EventArgs.Empty);

							this._keyPressEventHandledPheno = false;
						}
						else
						{
							//changing values in the datable causes TextChanged event to be fired
							//setting a flag to prevent it from happening
							this._keyPressEventHandledPheno = true;
							((DataGridTextBox)sender).Text = dt.Rows[row][column].ToString();
							this._keyPressEventHandledPheno = false;
							//BR_2.28
							GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.Common.InvalidKeyPressed());
						}
					}
						//user hit Del key and the grid cell is blank - refresh grid, do not run regex match
					else
					{
						//changing values in the datable causes TextChanged event to be fired
						//setting a flag to prevent it from happening
						this._keyPressEventHandledPheno = true;
						dt.Rows[row][column] = "";

						UpdateControlIndicator((row==0));
						this.dgControl.Refresh();
						onCurrentCellChanged(this.dgControl, EventArgs.Empty);

						this._keyPressEventHandledPheno = false;
					}
				}
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// This code traps each key stroke to allow movement to the next cell for the columns that only 
		/// require a single valid key stroke.
		/// Implements BR_2.28
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Key Press Event Args</param>
		private void PhenotypeTextBoxKeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			try
			{
				int row = this.dgPhenotype.CurrentCell.RowNumber;
				int column = this.dgPhenotype.CurrentCell.ColumnNumber;
				string cellText = string.Empty;
				string cellTextFuture = string.Empty;
				string KeyChar = string.Empty;
				string regPattern = string.Empty;
				bool findNextCell = false;
			
				TextBox c = (TextBox) sender;

				cellText = c.Text;
			
				// Let backspace and enter keys bypass
				if ((e.KeyChar == (int)Keys.Back) || (e.KeyChar == (int)Keys.Enter))
				{
					if (e.KeyChar == (int)Keys.Back)
					{
						DataTable dt = ((DataView)this.dgPhenotype.DataSource).Table;
						dt.Rows[row][column] = string.Empty;
						UpdatePhenotypeIndicator();
					}
					e.Handled = !char.IsControl(e.KeyChar);
					return;
				}
			
				// Turn single character to upper
				KeyChar = e.KeyChar.ToString().ToUpper()[0].ToString();

				// Obtain what the string will look like after key is pressed
				if (cellText.Length > 0)
				{
					cellTextFuture = cellText.Substring(0, c.SelectionStart) + KeyChar + cellText.Substring(c.SelectionStart + c.SelectionLength, cellText.Length - (c.SelectionLength + c.SelectionStart));
				}
				else
				{
					cellTextFuture = KeyChar;
				}

				// Test what type of column it is and then apply the regular expression

				if (column == 8)  // Interp
				{
					//CR 2653 removed I from the list of possible interpretations
					regPattern = @"(\A[PN]\z)";
					findNextCell = true;
				}
				else if (column == 3 || column == 4 ||				// IS	RT
					column == 5 || column == 6 || column == 7)		// 37	AHG	CC
				{
					regPattern = @"(\A[WFMR01234X]\z)";
					findNextCell = true;
				}
				//
				if (Regex.IsMatch(cellTextFuture, regPattern))
				{
					//changing values in the datable causes TextChanged event to be fired
					//setting a flag to prevent it from happening (CR 2792)
					this._keyPressEventHandledPheno = true;
					if (column == 8)
					{
						//Calling BR_41.12
						if ((cellTextFuture!="I") && (BOL.AntigenTyping.AntigenTypingMismatch(_drPhenotype,cellTextFuture)))
						{
							_drPhenotype[TABLE.BloodUnitStatus.QuarantineIndicator] = true;
							GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC041.AntigenTypingQuarantine());
						}
						else
						{
							_drPhenotype[TABLE.BloodUnitStatus.QuarantineIndicator] = false;
						}
						//
						//BR_56.29
						if ((cellTextFuture=="P") && (BOL.AntigenTyping.PatientAntigenTypingMismatch((Guid)_drPhenotype[TABLE.BloodUnit.BloodUnitGuid],Convert.ToInt32(_drPhenotype[TABLE.OrderableTest.OrderableTestId]),cellTextFuture)))
						{
							//Only prompt for a comment if we haven't already got one...
							if (_drPhenotype.IsNull(TABLE.ExceptionQc.ExceptionComment))
							{
								DlgOverrideComment dlg = new DlgOverrideComment("Typing Mismatch", Common.StrRes.SysErrMsg.UC041.IssuedUnitTypingMismatch().ResString, "PT");

                                //Bleh. Raising a form from a control. This is outside-the-norm in this application.
                                //Should probably be reworked as an event to bubble up to the control's form, but for now..
                                VbecsBaseForm tmpParent = (VbecsBaseForm)this.FindForm();
                                dlg.ShowDialogFromLockedParent(tmpParent, false);

								if (dlg.DialogResult != DialogResult.OK)
								{
									_drPhenotype[TABLE.ExceptionQc.ExceptionComment] = DBNull.Value;
									c.Text = string.Empty;
									cellTextFuture = string.Empty;
									findNextCell = false;
								}
								else
								{
									_drPhenotype[TABLE.ExceptionQc.ExceptionComment] = dlg.Comment;
								}
							}
						}
						else
						{
							_drPhenotype[TABLE.ExceptionQc.ExceptionComment] = DBNull.Value;
						}
					}
					//
					c.Text = cellTextFuture;
					c.SelectionStart = c.SelectionLength + 1;
					//
					DataTable dt = ((DataView)this.dgPhenotype.DataSource).Table;
					dt.Rows[row][column] = c.Text;
					UpdatePhenotypeIndicator();
					//
					if (findNextCell)
					{
						this.dgPhenotype.Direction = GridDirection.Down;
						this.dgPhenotype.FindNextCell();
					}
				
					this._keyPressEventHandledPheno = false;
				}
				else
				{
					//BR_2.28
					GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.Common.InvalidKeyPressed());
				}
				//
				e.Handled = true;
				return;			
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		/// <summary>
		/// This method handles entering invalid entries into the grid (CR 2792)
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void PhenotypeTextBox_TextChanged(object sender, EventArgs e)
		{
			if (this._keyPressEventHandledPheno || this.dgPhenotype.EnterKeyPressed == true || this.dgControl.EnterKeyPressed == true)
			{
				return;
			}
			else
			{
				int row = this.dgPhenotype.CurrentCell.RowNumber;
				int column = this.dgPhenotype.CurrentCell.ColumnNumber;
				DataTable dt = ((DataView)this.dgPhenotype.DataSource).Table;
			
				//forcing the validation of the grid
				if (sender is System.Windows.Forms.DataGridTextBox)
				{
					//if the grid cell has anything in it run the regex match
					if (((DataGridTextBox)sender).Text != "" && ((DataGridTextBox)sender).Text != "(null)")
					{
						string regPattern = "";

						// Test what type of column it is and then apply the regular expression
						if (column == 8)  // Interp
						{
							regPattern = @"(\A[PN]\z)";
						}
						else if (column == 3 || column == 4 ||				// IS	RT
							column == 5 || column == 6 || column == 7)		// 37	AHG	CC
						{
							regPattern = @"(\A[WFMR01234X]\z)";
						}

						if (Regex.IsMatch(((DataGridTextBox)sender).Text, regPattern))
						{
							//changing values in the datable causes TextChanged event to be fired
							//setting a flag to prevent it from happening
							this._keyPressEventHandledPheno = true;
							dt.Rows[row][column] = ((DataGridTextBox)sender).Text;
							
							//							if (column == 8)
							//							{
							//								//Calling BR_41.12
							//								if ((((DataGridTextBox)sender).Text!="I") && (BOL.AntigenTyping.AntigenTypingMismatch(_drPhenotype,((DataGridTextBox)sender).Text)))
							//								{
							//									_drPhenotype[TABLE.BloodUnitStatus.QuarantineIndicator] = true;
							//									GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC041.AntigenTypingQuarantine());
							//								}
							//								else
							//								{
							//									_drPhenotype[TABLE.BloodUnitStatus.QuarantineIndicator] = false;
							//								}
							//								//
							//								//BR_56.29
							//								if ((((DataGridTextBox)sender).Text=="P") && (BOL.AntigenTyping.PatientAntigenTypingMismatch((Guid)_drPhenotype[TABLE.BloodUnit.BloodUnitGuid],Convert.ToInt32(_drPhenotype[TABLE.OrderableTest.OrderableTestId]),((DataGridTextBox)sender).Text)))
							//								{
							//									//Only prompt for a comment if we haven't already got one...
							//									if (_drPhenotype.IsNull(TABLE.ExceptionQc.ExceptionComment))
							//									{
							//										DlgOverrideComment dlg = new DlgOverrideComment("Typing Mismatch", Common.StrRes.SysErrMsg.UC041.IssuedUnitTypingMismatch().ResString, "PT");
							//
							//										dlg.ParentFormGuid = this.ParentFormGuid;
							//										dlg.RefreshParentLockTimeEvent += new EventHandler(this.UserActivity);
							//
							//										if (dlg.ShowDialog(this.FindForm()) != DialogResult.OK)
							//										{
							//											_drPhenotype[TABLE.ExceptionQc.ExceptionComment] = DBNull.Value;
							//											c.Text = string.Empty;
							//											cellTextFuture = string.Empty;
							//											findNextCell = false;
							//										}
							//										else
							//										{
							//											_drPhenotype[TABLE.ExceptionQc.ExceptionComment] = dlg.Comment;
							//										}
							//									}
							//								}
							//								else
							//								{
							//									_drPhenotype[TABLE.ExceptionQc.ExceptionComment] = DBNull.Value;
							//								}
							//							}
							//

							UpdatePhenotypeIndicator();
							this.dgPhenotype.Refresh();
							onCurrentCellChanged(this.dgControl, EventArgs.Empty);

							this._keyPressEventHandledPheno = false;
						}
						else
						{
							//changing values in the datable causes TextChanged event to be fired
							//setting a flag to prevent it from happening
							this._keyPressEventHandledPheno = true;
							((DataGridTextBox)sender).Text = dt.Rows[row][column].ToString();
							this._keyPressEventHandledPheno = false;
							//BR_2.28
							GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.Common.InvalidKeyPressed());
						}
					}
						//user hit Del key and the grid cell is blank - refresh grid, do not run regex match
					else
					{
						//changing values in the datable causes TextChanged event to be fired
						//setting a flag to prevent it from happening
						this._keyPressEventHandledPheno = true;
						dt.Rows[row][column] = "";

						UpdatePhenotypeIndicator();
						this.dgPhenotype.Refresh();
						onCurrentCellChanged(this.dgControl, EventArgs.Empty);

						this._keyPressEventHandledPheno = false;
					}
				}
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// This code traps each key stroke to allow movement to the next cell for the columns that only 
		/// require a single valid key stroke.
		/// Implements BR_2.28
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Key Press Event Args</param>
		private void WeakDTextBoxKeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			try
			{
				this.OnUserActivity();

				int row = this.dgWeakD.CurrentCell.RowNumber;
				int column = this.dgWeakD.CurrentCell.ColumnNumber;
				string cellText = string.Empty;
				string cellTextFuture = string.Empty;
				string KeyChar = string.Empty;
				string regPattern = string.Empty;
				bool findNextCell = false;
			
				TextBox c = (TextBox) sender;

				cellText = c.Text;
			
				// Let backspace and enter keys bypass
				if ((e.KeyChar == (int)Keys.Back) || (e.KeyChar == (int)Keys.Enter))
				{
					if (e.KeyChar == (int)Keys.Back)
					{
						DataTable dt = ((DataView)this.dgWeakD.DataSource).Table;
						dt.Rows[row][column] = string.Empty;
						UpdateWeakDIndicator();
					}
					e.Handled = !char.IsControl(e.KeyChar);
					return;
				}
			
				// Turn single character to upper
				KeyChar = e.KeyChar.ToString().ToUpper()[0].ToString();

				// Obtain what the string will look like after key is pressed
				if (cellText.Length > 0)
				{
					cellTextFuture = cellText.Substring(0, c.SelectionStart) + KeyChar + cellText.Substring(c.SelectionStart + c.SelectionLength, cellText.Length - (c.SelectionLength + c.SelectionStart));
				}
				else
				{
					cellTextFuture = KeyChar;
				}

				// Test what type of column it is and then apply the regular expression

				if (column == 9)  // Interp
				{
					regPattern = @"(\A[PNI]\z)";
					findNextCell = true;
				}
				else if (column == 3 || column == 4 ||							// D37		DAHG	DCC
					column == 5 || column == 6 || column == 7 || column == 8)	// DC37		DcAHG	DcCC
				{
					regPattern = @"(\A[WFMR01234X]\z)";
					findNextCell = true;
				}
				//
				if (Regex.IsMatch(cellTextFuture, regPattern))
				{
					//changing values in the datable causes TextChanged event to be fired
					//setting a flag to prevent it from happening (CR 2792)
					this._keyPressEventHandledWeakD = true;
					
					if (column == 9)
					{
						//Calling BR_41.22
						if (BOL.AntigenTyping.WeakDPositiveOnRhNegativeUnit(_drWeakD, cellTextFuture))
						{
							_drWeakD[TABLE.BloodUnitStatus.QuarantineIndicator] = true;
							GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC041.WeakDQuarantine());
						}
						else //if already quarantined, don't need to check BR_41.12
						{
							//Calling BR_41.12
							if ((cellTextFuture.Trim()!="I") && (BOL.AntigenTyping.AntigenTypingMismatch(_drWeakD,cellTextFuture)))
							{
								_drWeakD[TABLE.BloodUnitStatus.QuarantineIndicator] = true;
								GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC041.AntigenTypingQuarantine());
							}
							else
							{
								_drWeakD[TABLE.BloodUnitStatus.QuarantineIndicator] = false;
							}
						}
					}
					//
					//
					//BR_56.29
					if ((cellTextFuture=="P") && (BOL.AntigenTyping.PatientAntigenTypingMismatch((Guid)_drWeakD[TABLE.BloodUnit.BloodUnitGuid],Convert.ToInt32(_drWeakD[TABLE.OrderableTest.OrderableTestId]),cellTextFuture)))
					{
						//Only prompt for a comment if we haven't already got one...
						if (_drWeakD.IsNull(TABLE.ExceptionQc.ExceptionComment))
						{
							DlgOverrideComment dlg = new DlgOverrideComment("Typing Mismatch", Common.StrRes.SysErrMsg.UC041.IssuedUnitTypingMismatch().ResString, "PT");

                            VbecsBaseForm tmpParent = (VbecsBaseForm)this.FindForm();
                            dlg.ShowDialogFromLockedParent(tmpParent, false);

							if (dlg.DialogResult != DialogResult.OK)
							{
								_drWeakD[TABLE.ExceptionQc.ExceptionComment] = DBNull.Value;
								c.Text = string.Empty;
								cellTextFuture = string.Empty;
								findNextCell = false;
							}
							else
							{
								_drWeakD[TABLE.ExceptionQc.ExceptionComment] = dlg.Comment;
							}
						}
					}
					else
					{
						_drWeakD[TABLE.ExceptionQc.ExceptionComment] = DBNull.Value;
					}
					//
					c.Text = cellTextFuture;
					c.SelectionStart = c.SelectionLength + 1;
					//
					DataTable dt = ((DataView)this.dgWeakD.DataSource).Table;
					dt.Rows[row][column] = c.Text;
					UpdateWeakDIndicator();
					//
					//
					if (findNextCell)
					{
						this.dgWeakD.Direction = GridDirection.Down;
						this.dgWeakD.FindNextCell();
					}
				
					this._keyPressEventHandledWeakD = false;
				}
				else
				{
					//BR_2.28
					GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.Common.InvalidKeyPressed());
				}
				//
				e.Handled = true;
				return;			
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		/// <summary>
		/// This method handles entering invalid entries into the grid (CR 2792)
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void WeakDTextBox_TextChanged(object sender, EventArgs e)
		{
			if (this._keyPressEventHandledWeakD || this.dgWeakD.EnterKeyPressed == true)
			{
				return;
			}
			else
			{
				int row = this.dgWeakD.CurrentCell.RowNumber;
				int column = this.dgWeakD.CurrentCell.ColumnNumber;
				DataTable dt = ((DataView)this.dgWeakD.DataSource).Table;
			
				//forcing the validation of the grid
				if (sender is System.Windows.Forms.DataGridTextBox)
				{
					//if the grid cell has anything in it run the regex match
					if (((DataGridTextBox)sender).Text != "" && ((DataGridTextBox)sender).Text != "(null)")
					{
						string regPattern = "";

						// Test what type of column it is and then apply the regular expression
						if (column == 8)  // Interp
						{
							regPattern = @"(\A[PN]\z)";
						}
						else if (column == 3 || column == 4 ||				// IS	RT
							column == 5 || column == 6 || column == 7)		// 37	AHG	CC
						{
							regPattern = @"(\A[WFMR01234X]\z)";
						}

						if (Regex.IsMatch(((DataGridTextBox)sender).Text, regPattern))
						{
							//changing values in the datable causes TextChanged event to be fired
							//setting a flag to prevent it from happening
							this._keyPressEventHandledWeakD = true;
							dt.Rows[row][column] = ((DataGridTextBox)sender).Text;
							
							UpdateWeakDIndicator();
							this.dgWeakD.Refresh();
							onCurrentCellChanged(this.dgControl, EventArgs.Empty);

							this._keyPressEventHandledWeakD = false;
						}
						else
						{
							//changing values in the datable causes TextChanged event to be fired
							//setting a flag to prevent it from happening
							this._keyPressEventHandledWeakD = true;
							((DataGridTextBox)sender).Text = dt.Rows[row][column].ToString();
							this._keyPressEventHandledWeakD = false;
							//BR_2.28
							GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.Common.InvalidKeyPressed());
						}
					}
						//user hit Del key and the grid cell is blank - refresh grid, do not run regex match
					else
					{
						//changing values in the datable causes TextChanged event to be fired
						//setting a flag to prevent it from happening
						this._keyPressEventHandledWeakD = true;
						dt.Rows[row][column] = "";

						UpdateWeakDIndicator();
						this.dgWeakD.Refresh();
						onCurrentCellChanged(this.dgControl, EventArgs.Empty);

						this._keyPressEventHandledWeakD = false;
					}
				}
			}
		}

		#endregion

		#region Update Indicators

		/// <summary>
		/// Updates the datagrid indicator to indicate the status of test results
		/// </summary>
		private void UpdateControlIndicator(bool controltype)
		{
			string interp = BOL.AntigenTyping.InterpretPhenotypeResults(_drControl);
			//			
			if (interp == string.Empty || (_drControl[ARTIFICIAL.ControlInterp].ToString() == string.Empty))
			{
				//there are missing test results
				_drControl[ARTIFICIAL.ControlInterp] = string.Empty;
				_drControl[ARTIFICIAL.Indicator] = string.Empty;
				_drControl[ARTIFICIAL.IndicatorMessage] = string.Empty;
			}
			else if (interp == "X")
			{
				//invalid test results
				_drControl[ARTIFICIAL.SystemControlInterp] = interp;

//				if (_drControl[ARTIFICIAL.ControlComment].ToString() != string.Empty)
//				{
//					_drControl[ARTIFICIAL.Indicator] = "W";
//				}
//				else
//				{
					_drControl[ARTIFICIAL.Indicator] = "E";
//				}
				//
				Common.ReactivityPhase phase = (Common.ReactivityPhase)Convert.ToInt32(_drControl[TABLE.ReactivityPhase.ReactivityPhaseCode]);
				if ((phase == Common.ReactivityPhase.ISandRT) && (_drControl[ARTIFICIAL.RT].ToString() == "X"))
				{
					_drControl[ARTIFICIAL.IndicatorMessage] = _errorMessage3;
				}
				else
				{
					_drControl[ARTIFICIAL.IndicatorMessage] = _errorMessage2;
				}
			}
			else if (interp != _drControl[ARTIFICIAL.ControlInterp].ToString())
			{
				_drControl[ARTIFICIAL.SystemControlInterp] = interp;
				_drControl[ARTIFICIAL.Indicator] = "E";
				_drControl[ARTIFICIAL.IndicatorMessage] = _errorMessage2;
			}
			else if (controltype & (interp == "N"))
			{
				_drControl[ARTIFICIAL.SystemControlInterp] = interp;
				_drControl[ARTIFICIAL.Indicator] = "E";
				_drControl[ARTIFICIAL.IndicatorMessage] = Common.StrRes.Tooltips.UC041.InvalidPosControlInterp().ResString;
			}
			else if ((!controltype) & (interp == "P"))
			{
				_drControl[ARTIFICIAL.SystemControlInterp] = interp;
				_drControl[ARTIFICIAL.Indicator] = "E";
				_drControl[ARTIFICIAL.IndicatorMessage] = Common.StrRes.Tooltips.UC041.InvalidNegControlInterp().ResString;
			}
			else
			{
				_drControl[ARTIFICIAL.SystemControlInterp] = interp;
				_drControl[ARTIFICIAL.Indicator] = "V";
				_drControl[ARTIFICIAL.IndicatorMessage] = string.Empty;
			}
		
			//CR 2764 Update the indicator for units after the control indicator was updated 
			//this will allow user to save results if the QC testing was completed otherwise the unit grid would still show an error saying that QC is not done
			foreach (DataRow dr in this._dataTablePhenotype.Rows)
			{
				this._drPhenotype = dr;
				UpdatePhenotypeIndicator();
			}
		}

		/// <summary>
		/// Updates the datagrid indicator to indicate the status of test results
		/// </summary>
		private void UpdatePhenotypeIndicator()
		{
			//CR 2764 check if QC was completed. Set indicator to E if it was not
			bool qcRows = false;

			if (this._dataTableControl != null)
			{
				if (_dataTableControl.Rows.Count > 0)
					qcRows = true;
			}

			if (qcRows)
			{
				DataRow drPos = _dataTableControl.Rows[0];
				DataRow drNeg = _dataTableControl.Rows[1];

				if (drPos.IsNull(ARTIFICIAL.Indicator) || drNeg.IsNull(ARTIFICIAL.Indicator))
				{
					_drPhenotype[ARTIFICIAL.Indicator] = "E";
					_drPhenotype[ARTIFICIAL.IndicatorMessage] = Common.StrRes.SysErrMsg.UC041.ControlCellsMustBeCompleted().ResString;
					return;
				}
				else
				{
					if (drPos[ARTIFICIAL.Indicator].ToString().Trim() == "E" || drNeg[ARTIFICIAL.Indicator].ToString().Trim() == "E" ||
						drPos[ARTIFICIAL.Indicator].ToString().Trim() == "" || drNeg[ARTIFICIAL.Indicator].ToString().Trim() == "")
					{
						_drPhenotype[ARTIFICIAL.Indicator] = "E";
						_drPhenotype[ARTIFICIAL.IndicatorMessage] = Common.StrRes.SysErrMsg.UC041.ControlCellsMustBeCompleted().ResString;
						return;
					}
				}
			}
			//
			string interp = BOL.AntigenTyping.InterpretPhenotypeResults(_drPhenotype);
			//
			if (interp == string.Empty || (_drPhenotype[ARTIFICIAL.Interp].ToString() == string.Empty))
			{
				//there are missing test results
				_drPhenotype[ARTIFICIAL.Interp] = string.Empty;
				_drPhenotype[ARTIFICIAL.Indicator] = string.Empty;
				_drPhenotype[ARTIFICIAL.IndicatorMessage] = string.Empty;
			}
			else if (interp == "X")
			{
				//invalid test results
				_drPhenotype[TABLE.ValidRhResult.SystemInterp] = interp;
				_drPhenotype[ARTIFICIAL.Indicator] = "E";
				Common.ReactivityPhase phase = (Common.ReactivityPhase)Convert.ToInt32(_drPhenotype[TABLE.ReactivityPhase.ReactivityPhaseCode]);
				if ((phase == Common.ReactivityPhase.ISandRT) && (_drPhenotype[ARTIFICIAL.RT].ToString() == "X"))
				{
					_drPhenotype[ARTIFICIAL.IndicatorMessage] = _errorMessage3;
				}
				else
				{
					_drPhenotype[ARTIFICIAL.IndicatorMessage] = _errorMessage2;
				}
			}
			else if (interp != _drPhenotype[ARTIFICIAL.Interp].ToString())
			{
				_drPhenotype[TABLE.ValidRhResult.SystemInterp] = interp;
				_drPhenotype[ARTIFICIAL.Indicator] = "E";
				_drPhenotype[ARTIFICIAL.IndicatorMessage] = _errorMessage2;
			}
			else
			{
				_drPhenotype[TABLE.ValidRhResult.SystemInterp] = interp;
				if ((bool)_drPhenotype[TABLE.BloodUnitStatus.QuarantineIndicator])
				{
					_drPhenotype[ARTIFICIAL.Indicator] = "W";
					_drPhenotype[ARTIFICIAL.IndicatorMessage] = Common.StrRes.InfoMsg.UC041.AntigenTypingQuarantine().ResString;
				}
				else
				{
					_drPhenotype[ARTIFICIAL.Indicator] = "V";
					_drPhenotype[ARTIFICIAL.IndicatorMessage] = string.Empty;
				}
			}
		}

		/// <summary>
		/// Updates the datagrid indicator to indicate the status of test results
		/// </summary>
		private void UpdateWeakDIndicator()
		{
			//
			string antiDInterp = "";
			string DControlInterp = "";
			string interp = BOL.AntigenTyping.InterpretWeakDResults(_drWeakD, ref antiDInterp, ref DControlInterp);
			//
			if (interp == string.Empty || (_drWeakD[ARTIFICIAL.Interp].ToString() == string.Empty))
			{
				//there are missing test results
				_drWeakD[ARTIFICIAL.Interp] = string.Empty;
				_drWeakD[ARTIFICIAL.Indicator] = string.Empty;
				_drWeakD[ARTIFICIAL.IndicatorMessage] = string.Empty;
			}
			else if (interp == "X") 
			{
				//invalid test results
				_drWeakD[TABLE.ValidRhResult.SystemInterp] = interp;
				_drWeakD[ARTIFICIAL.Indicator] = "E";
				_drWeakD[ARTIFICIAL.IndicatorMessage] = _errorMessage2;
			}
			else if (interp == "XX")
			{
				_drWeakD[TABLE.ValidRhResult.SystemInterp] = interp;
				_drWeakD[ARTIFICIAL.Indicator] = "E";
				_drWeakD[ARTIFICIAL.IndicatorMessage] = Common.StrRes.Tooltips.Common.InvalidDControl().ResString;
			}
			else if (interp != _drWeakD[ARTIFICIAL.Interp].ToString())
			{
				if (antiDInterp == "N" && 
					DControlInterp == "N" && 
					_drWeakD[ARTIFICIAL.Interp].ToString().Trim() == "I" &&
					interp == "N")
				{
					_drWeakD[ARTIFICIAL.Indicator] = "V";
					_drWeakD[ARTIFICIAL.IndicatorMessage] = string.Empty;
				}
				else
				{
					_drWeakD[TABLE.ValidRhResult.SystemInterp] = interp;
					_drWeakD[ARTIFICIAL.Indicator] = "E";
					_drWeakD[ARTIFICIAL.IndicatorMessage] = _errorMessage2;
				}
			}
			else
			{
				_drWeakD[TABLE.ValidRhResult.SystemInterp] = interp;
				if ((bool)_drWeakD[TABLE.BloodUnitStatus.QuarantineIndicator])
				{
					_drWeakD[ARTIFICIAL.Indicator] = "W";
					if (interp == "P" ||
						interp == "I")  //CR 2856)
					{
						_drWeakD[ARTIFICIAL.IndicatorMessage] = Common.StrRes.InfoMsg.UC041.WeakDQuarantine().ResString;
					}
					else
					{
						_drWeakD[ARTIFICIAL.IndicatorMessage] = Common.StrRes.InfoMsg.UC041.AntigenTypingQuarantine().ResString;
					}
				}
				else
				{
					if (antiDInterp == "N" && 
						DControlInterp == "P" && 
						_drWeakD[ARTIFICIAL.Interp].ToString().Trim() == "I" &&
						interp == "I")
					{
						_drWeakD[TABLE.ValidRhResult.SystemInterp] = interp;
						_drWeakD[ARTIFICIAL.Indicator] = "E";
						_drWeakD[ARTIFICIAL.IndicatorMessage] = _errorMessage2;
					}
					else
					{
						_drWeakD[ARTIFICIAL.Indicator] = "V";
						_drWeakD[ARTIFICIAL.IndicatorMessage] = string.Empty;
					}
				}
				//
			}
		}

		#endregion

		#region Display Valid Entries

		/// <summary>
		/// Displays the valid values for each column in the legend.
		/// Implements BR_2.32, 2.34
		/// </summary>
		/// <param name="column"></param>
		public void SetValidPhenotypeEntries(int column)
		{		
			// Test what type of column it is and then apply the regular expression
			
			if (column == 8)  // RInterp
			{
				//CR 2653 removed I from the list of possible interpretations 
				_validEntries = "P = Positive    N = Negative";
			}
			else if (column == 3 || column == 4 ||			// IS	RT  CC
				column == 5 || column == 6 || column == 7)	// 37	AHG
			{
				_validEntries = "0 = No Agglutination, R = Rouleaux, 1 = 1+, 2 = 2+, 3 = 3+, 4 = 4+, W = Weak, F = Mixed Field, M = Microscopic, X = Not Tested";
			}
			else if (column == 9)		// Comment
			{
				_validEntries = "Any Text";
			}
			else
			{
				_validEntries = string.Empty;
			}
		}

		/// <summary>
		/// Displays the valid values for each column in the legend.
		/// Implements BR_2.32, 2.34
		/// </summary>
		/// <param name="column"></param>
		public void SetValidControlEntries(int column)
		{		
			// Test what type of column it is and then apply the regular expression
			
			if (column == 10)  // ControlInterp
			{
				//CR 2653 removed I from the list of possible interpretations
				_validEntries = "P = Positive    N = Negative";
			}
			else if (column == 4)	// Vial ID
			{
				_validEntries = "1 or 2 digit Vial identifier, as listed on the antigram.";
			}
			else if (column == 5 || column == 6 ||			// IS	RT	CC
				column == 7 || column == 8 || column == 9)	// 37	AHG
			{
				_validEntries = "0 = No Agglutination, R = Rouleaux, 1 = 1+, 2 = 2+, 3 = 3+, 4 = 4+, W = Weak, F = Mixed Field, M = Microscopic, X = Not Tested";
			}
			else if (column == 11)		// ControlComment
			{
				_validEntries = "Any Text";
			}
			else
			{
				_validEntries = string.Empty;
			}
		}

		/// <summary>
		/// Displays the valid values for each column in the legend.
		/// Implements BR_2.32, 2.34
		/// </summary>
		/// <param name="column"></param>
		public void SetValidWeakDEntries(int column)
		{		
			// Test what type of column it is and then apply the regular expression
			
			if (column == 9)  // Interp
			{
				_validEntries = "P = Positive    N = Negative    I = Inconclusive";
			}
			else if (column == 3 || column == 4 ||		// D37	Dc37
				column == 5 || column == 6 ||			// DAHG	DcAHG
				column == 7 || column == 8)				// DCC  DcCC
			{
				_validEntries = "0 = No Agglutination, R = Rouleaux, 1 = 1+, 2 = 2+, 3 = 3+, 4 = 4+, W = Weak, F = Mixed Field, M = Microscopic, X = Not Tested";
			}
			else if (column == 10)		// Comment
			{
				_validEntries = "Any Text";
			}
			else
			{
				_validEntries = string.Empty;
			}
		}

		#endregion

		#region Current Cell Changed Event Handlers

		/// <summary>
		/// CurrentCellChanged Event
		/// </summary>
		public event EventHandler CurrentCellChanged
		{
			add
			{
				onCurrentCellChanged += value;
			}
			remove
			{
				onCurrentCellChanged -= value;
			}
		}

		/// <summary>
		/// Phenotype Enter Event Handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void dgPhenotype_Enter(object sender, System.EventArgs e)
		{
			//CR 2835
			int col = this.dgPhenotype.CurrentCell.ColumnNumber;
			this.SetValidPhenotypeEntries(col);

			//CR 2831
			if (col == 0)
			{
				this.dgPhenotype.Direction = GridDirection.Right;
				this.dgPhenotype.FindNextCell();
			}
			
			if (onCurrentCellChanged != null)
			{
				onCurrentCellChanged(sender,e);
			}
		}

		/// <summary>
		/// Control Enter Event Handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void dgControl_Enter(object sender, System.EventArgs e)
		{
			//CR 2835
			int col = this.dgControl.CurrentCell.ColumnNumber;
			this.SetValidControlEntries(col);
			if (onCurrentCellChanged != null)
			{
				onCurrentCellChanged(sender,e);
			}
		}

		/// <summary>
		/// Updates the indicator flag after each cell is edited.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void dgPhenotype_CurrentCellChanged(object sender, System.EventArgs e)
		{
			try
			{
				this.OnUserActivity();

				int col = this.dgPhenotype.CurrentCell.ColumnNumber;
				int row = this.dgPhenotype.CurrentCell.RowNumber;
				//
				this._drPhenotype = this._dataTablePhenotype.Rows[this.dgPhenotype.CurrentRowIndex];
				//
				if (col < 3)
				{
					this.dgPhenotype.Direction = GridDirection.Right;
					this.dgPhenotype.FindNextCell();
					return;
				}
				//

				if (col == 9)
				{
					if (!_drPhenotype.IsNull(ARTIFICIAL.Interp) && _drPhenotype[ARTIFICIAL.Interp].ToString().Length==0)
					{
						//can't enter a comment until an interp is entered
						this.dgPhenotype.Direction = GridDirection.Left;
						this.dgPhenotype.FindNextCell();
						return;
					}
					//
					cmbComment.Text = ((DataView)this.dgPhenotype.DataSource).Table.Rows[this.dgPhenotype.CurrentRowIndex][ARTIFICIAL.Comment].ToString();
					//
					cmbComment.Show();
					cmbComment.Focus();
				}
				//
				if (col == 8)
				{
					if (((Common.Utility.GetReactivityPhaseTextFromCode(_drPhenotype[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.IS)>-1) && (this._drPhenotype[ARTIFICIAL.IS].ToString().Length==0))||
						((Common.Utility.GetReactivityPhaseTextFromCode(_drPhenotype[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.RT)>-1) && (this._drPhenotype[ARTIFICIAL.RT].ToString().Length==0))||
						((Common.Utility.GetReactivityPhaseTextFromCode(_drPhenotype[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.C37)>-1) && (this._drPhenotype[ARTIFICIAL.C37].ToString().Length==0))||
						((Common.Utility.GetReactivityPhaseTextFromCode(_drPhenotype[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.AHG)>-1) && (this._drPhenotype[ARTIFICIAL.AHG].ToString().Length==0))||
						((Common.Utility.GetReactivityPhaseTextFromCode(_drPhenotype[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.AHG)>-1) && (this._drPhenotype[ARTIFICIAL.CC].ToString().Length==0)))
					{
						//Can't enter an interp, if the phases aren't complete
						this.dgPhenotype.Direction = GridDirection.Left;
						this.dgPhenotype.FindNextCell();
						return;
					}
				}
				//
				DisplayLotInformation((Guid)_drPhenotype[TABLE.Reagent.ReagentGuid]);
				//
				if (col == 2)
				{
					this.dgPhenotype.Direction = GridDirection.Right;
					this.dgPhenotype.FindNextCell();
				}
				//Don't allow edit of previously entered test results
				if (((col < 3) && ((bool)this._drPhenotype[ARTIFICIAL.PartiallyCompleted] == true))||
					((col == 3) && (!(bool)this._drPhenotype[ARTIFICIAL.ISSave] || (Common.Utility.GetReactivityPhaseTextFromCode(_drPhenotype[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.IS)==-1)))||
					((col == 4) && (!(bool)this._drPhenotype[ARTIFICIAL.RTSave] || (Common.Utility.GetReactivityPhaseTextFromCode(_drPhenotype[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.RT)==-1)))||
					((col == 5) && (!(bool)this._drPhenotype[ARTIFICIAL.C37Save] || (Common.Utility.GetReactivityPhaseTextFromCode(_drPhenotype[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.C37)==-1)))||
					((col == 6) && (!(bool)this._drPhenotype[ARTIFICIAL.AHGSave] || (Common.Utility.GetReactivityPhaseTextFromCode(_drPhenotype[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.AHG)==-1)))||
					((col == 7) && (!(bool)this._drPhenotype[ARTIFICIAL.CCSave] || (Common.Utility.GetReactivityPhaseTextFromCode(_drPhenotype[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.AHG)==-1)))||
					((col == 8) && (!(bool)this._drPhenotype[ARTIFICIAL.InterpSave])))
				{
					this.dgPhenotype.FindNextCell();
					//
					//If the user clicks in a read-only cell the find next cell might fail.
					//So... change the direction and try again - cos there is always space in the same grid
					if ((col==this.dgPhenotype.CurrentCell.ColumnNumber) &&
						(row==this.dgPhenotype.CurrentCell.RowNumber) &&
						(this.dgPhenotype.Direction == GridDirection.Down))
					{
						this.dgPhenotype.Direction = GridDirection.Right;
						this.dgPhenotype.FindNextCell();
					}
				}
				else
				{
					this.SetValidPhenotypeEntries(col);
				}
				//
				if (onCurrentCellChanged != null)
				{
					onCurrentCellChanged(sender,e);
				}
				//
				//return;
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		/// <summary>
		/// Updates the indicator flag after each cell is edited.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void dgControl_CurrentCellChanged(object sender, System.EventArgs e)
		{
			try
			{
				this.OnUserActivity();

				int col = this.dgControl.CurrentCell.ColumnNumber;
				int row = this.dgControl.CurrentCell.RowNumber;
				//
				this._drControl = this._dataTableControl.Rows[this.dgControl.CurrentRowIndex];
				//
				if (col < 2)
				{
					this.dgControl.Direction = GridDirection.Right;
					this.dgControl.FindNextCell();
					return;
				}
				//
				if (col == 2)
				{
					if ((bool)this._drControl[ARTIFICIAL.PartiallyCompleted] == true)
					{
						this.dgControl.Direction = GridDirection.Right;
						this.dgControl.FindNextCell();
						return;
					}
					cmbReagentType.Items.Clear();
					foreach(DataRow drType in _dtReagentTypes.Rows)
					{
						cmbReagentType.Items.Add(drType[TABLE.ReagentType.ReagentTypeName].ToString());
					}
					//
					cmbReagentType.Text = _drControl[ARTIFICIAL.ReagentType].ToString();
					//
					cmbReagentType.Show();
					cmbReagentType.Focus();
				}
				//if ((col == 3) && (cmbReagentType.SelectedIndex>-1))
				if (col == 3)
				{
					if ((bool)this._drControl[ARTIFICIAL.PartiallyCompleted] == true)
					{
						this.dgControl.Direction = GridDirection.Right;
						this.dgControl.FindNextCell();
						return;
					}
					DataTable dtReagents;
					if (row == 0)
					{
						_dtPosReagents = BOL.Reagent.GetReagentsByType(_drControl[TABLE.VamcDivision.DivisionCode].ToString(), this._posReagentTypeID);
						dtReagents = _dtPosReagents;
					}
					else
					{
						_dtNegReagents = BOL.Reagent.GetReagentsByType(_drControl[TABLE.VamcDivision.DivisionCode].ToString(), this._negReagentTypeID);
						dtReagents = _dtNegReagents;
					}
					//
					cmbLotNumber.Items.Clear();
					foreach(DataRow drReagent in dtReagents.Rows)
					{
						cmbLotNumber.Items.Add(drReagent[TABLE.Reagent.LotNumber].ToString());
					}
					//
					cmbLotNumber.Text = _drControl[TABLE.Reagent.LotNumber].ToString();
					//
					cmbLotNumber.Show();
					cmbLotNumber.Focus();
				}
				//
				if (col == 10)
				{
					if (((Common.Utility.GetReactivityPhaseTextFromCode(_drControl[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.IS)>-1) && (this._drControl[ARTIFICIAL.IS].ToString().Length==0))||
						((Common.Utility.GetReactivityPhaseTextFromCode(_drControl[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.RT)>-1) && (this._drControl[ARTIFICIAL.RT].ToString().Length==0))||
						((Common.Utility.GetReactivityPhaseTextFromCode(_drControl[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.C37)>-1) && (this._drControl[ARTIFICIAL.C37].ToString().Length==0))||
						((Common.Utility.GetReactivityPhaseTextFromCode(_drControl[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.AHG)>-1) && (this._drControl[ARTIFICIAL.AHG].ToString().Length==0))||
						((Common.Utility.GetReactivityPhaseTextFromCode(_drControl[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.AHG)>-1) && (this._drControl[ARTIFICIAL.CC].ToString().Length==0)))
					{
						//Can't enter an interp, if the phases aren't complete
						this.dgControl.Direction = GridDirection.Left;
						this.dgControl.FindNextCell();
						return;
					}
				}
				//
				if (col == 11)
				{
					if (!_drControl.IsNull(ARTIFICIAL.ControlInterp) && _drControl[ARTIFICIAL.ControlInterp].ToString().Length==0)
					{
						//can't enter a comment until an interp is entered
						this.dgControl.Direction = GridDirection.Left;
						this.dgControl.FindNextCell();
						return;
					}
					cmbControlComment.Text = _drControl[ARTIFICIAL.ControlComment].ToString();
					//
					cmbControlComment.Show();
					cmbControlComment.Focus();
				}
				//
				DisplayLotInformation((Guid)_drControl[ARTIFICIAL.ControlReagentGuid]);
				//
				UpdateControlIndicator((row==0));
				//
				if (col == 1)
				{
					this.dgControl.Direction = GridDirection.Right;
					this.dgControl.FindNextCell();
				}
				//Don't allow edit of previously entered test results
				if (((col >1) && (col <5) && ((bool)this._drControl[ARTIFICIAL.PartiallyCompleted] == true))||
					((col == 5) && (!(bool)this._drControl[ARTIFICIAL.ISSave] || (Common.Utility.GetReactivityPhaseTextFromCode(_drControl[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.IS)==-1)))||
					((col == 6) && (!(bool)this._drControl[ARTIFICIAL.RTSave] || (Common.Utility.GetReactivityPhaseTextFromCode(_drControl[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.RT)==-1)))||
					((col == 7) && (!(bool)this._drControl[ARTIFICIAL.C37Save] || (Common.Utility.GetReactivityPhaseTextFromCode(_drControl[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.C37)==-1)))||
					((col == 8) && (!(bool)this._drControl[ARTIFICIAL.AHGSave] || (Common.Utility.GetReactivityPhaseTextFromCode(_drControl[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.AHG)==-1)))||
					((col == 9) && (!(bool)this._drControl[ARTIFICIAL.CCSave] || (Common.Utility.GetReactivityPhaseTextFromCode(_drControl[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.AHG)==-1)))||
					((col == 10) && (!(bool)this._drControl[ARTIFICIAL.ControlInterpSave])))
				{
					this.dgControl.FindNextCell();
					//
					//If the user clicks in a read-only cell the find next cell might fail.
					//So... change the direction and try again - cos there is always space in the same grid
					if ((col==this.dgControl.CurrentCell.ColumnNumber) &&
						(row==this.dgControl.CurrentCell.RowNumber) &&
						(this.dgControl.Direction == GridDirection.Down))
					{
						this.dgControl.Direction = GridDirection.Right;
						this.dgControl.FindNextCell();
					}
				}
				else
				{
					this.SetValidControlEntries(col);
				}
				//
				//			if (((Common.Utility.GetReactivityPhaseTextFromCode(_drControl[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.IS)==-1) && (col == 5)) ||
				//				((Common.Utility.GetReactivityPhaseTextFromCode(_drControl[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.RT)==-1) && (col == 6)) ||
				//				((Common.Utility.GetReactivityPhaseTextFromCode(_drControl[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.C37)==-1) && (col == 7)) ||
				//				((Common.Utility.GetReactivityPhaseTextFromCode(_drControl[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.AHG)==-1) && (col == 8))||
				//				((Common.Utility.GetReactivityPhaseTextFromCode(_drControl[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.AHG)==-1) && (col == 9)))
				//			{
				//				this.dgControl.FindNextCell();
				//				return;
				//			}
				//
				if (onCurrentCellChanged != null)
				{
					onCurrentCellChanged(sender,e);
				}
				//
				//return;
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		/// <summary>
		/// Updates the indicator flag after each cell is edited.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void dgWeakD_CurrentCellChanged(object sender, System.EventArgs e)
		{
			try
			{
				this.OnUserActivity();

				int col = this.dgWeakD.CurrentCell.ColumnNumber;
				int row = this.dgWeakD.CurrentCell.RowNumber;
				//
				this._drWeakD = this._dataTableWeakD.Rows[this.dgWeakD.CurrentRowIndex];
				//
				if (col < 3)
				{
					this.dgWeakD.Direction = GridDirection.Right;
					this.dgWeakD.FindNextCell();
					return;
				}
				//
				if (col == 10)
				{
					if (!_drWeakD.IsNull(ARTIFICIAL.Interp) && _drWeakD[ARTIFICIAL.Interp].ToString().Length==0)
					{
						//can't enter a comment until an interp is entered
						this.dgWeakD.Direction = GridDirection.Left;
						this.dgWeakD.FindNextCell();
						return;
					}
					//
					cmbWeakDComment.Text = _drWeakD[ARTIFICIAL.Comment].ToString();
					//
					cmbWeakDComment.Show();
					cmbWeakDComment.Focus();
				}
				//
				if (col == 9)
				{
					if (((Common.Utility.GetReactivityPhaseTextFromCode(_drWeakD[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.C37)>-1) && (this._drWeakD[ARTIFICIAL.D37].ToString().Length==0))||
						((Common.Utility.GetReactivityPhaseTextFromCode(_drWeakD[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.C37)>-1) && (this._drWeakD[ARTIFICIAL.Dc37].ToString().Length==0))||
						((Common.Utility.GetReactivityPhaseTextFromCode(_drWeakD[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.AHG)>-1) && (this._drWeakD[ARTIFICIAL.DAHG].ToString().Length==0))||
						((Common.Utility.GetReactivityPhaseTextFromCode(_drWeakD[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.AHG)>-1) && (this._drWeakD[ARTIFICIAL.DcAHG].ToString().Length==0))||
						((Common.Utility.GetReactivityPhaseTextFromCode(_drWeakD[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.CC)>-1) && (this._drWeakD[ARTIFICIAL.DCC].ToString().Length==0))||
						((Common.Utility.GetReactivityPhaseTextFromCode(_drWeakD[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.CC)>-1) && (this._drWeakD[ARTIFICIAL.DcCC].ToString().Length==0)))
					{
						//Can't enter an interp, if the phases aren't complete
						this.dgWeakD.Direction = GridDirection.Left;
						this.dgWeakD.FindNextCell();
						return;
					}
				}
				//
				if ((col == 4)||(col == 6)||(col == 8))
				{
					DisplayLotInformation((Guid)_drWeakD[ARTIFICIAL.DControlReagentGuid]);
				}
				else
				{
					DisplayLotInformation((Guid)_drWeakD[ARTIFICIAL.AntiDReagentGuid]);
				}
				//
				UpdateWeakDIndicator();
				//
				if (col == 2)
				{
					this.dgWeakD.Direction = GridDirection.Right;
					this.dgWeakD.FindNextCell();
				}
				//			//
				//			//Don't allow entry if D Control not part of daily QC
				//			if (((_drWeakD[ARTIFICIAL.Dc37] == DBNull.Value) && (col == 4)) ||
				//				((_drWeakD[ARTIFICIAL.DcAHG] == DBNull.Value) && (col == 6)) ||
				//				((_drWeakD[ARTIFICIAL.DcCC] == DBNull.Value) && (col == 8)))
				//			{
				//				this.dgWeakD.FindNextCell();
				//				return;
				//			}
				//			//Don't allow edit of previously entered test results
				//			if (((col == 3) && ((bool)this._drWeakD[ARTIFICIAL.D37Save] == false))||
				//				((col == 4) && ((bool)this._drWeakD[ARTIFICIAL.Dc37Save] == false))||
				//				((col == 5) && ((bool)this._drWeakD[ARTIFICIAL.DAHGSave] == false))||
				//				((col == 6) && ((bool)this._drWeakD[ARTIFICIAL.DcAHGSave] == false))||
				//				((col == 7) && ((bool)this._drWeakD[ARTIFICIAL.DCCSave] == false))||
				//				((col == 8) && ((bool)this._drWeakD[ARTIFICIAL.DcCCSave] == false))||
				//				((col == 9) && ((bool)this._drWeakD[ARTIFICIAL.InterpSave] == false)))
				//			{
				//				this.dgWeakD.FindNextCell();
				//				return;
				//			}
				//Don't allow edit of previously entered test results
				if (((col < 3) && ((bool)this._drWeakD[ARTIFICIAL.PartiallyCompleted] == true))||
					((col == 3) && (!(bool)this._drWeakD[ARTIFICIAL.D37Save] || (Common.Utility.GetReactivityPhaseTextFromCode(_drWeakD[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.C37)==-1)))||
					((col == 4) && (!(bool)this._drWeakD[ARTIFICIAL.Dc37Save] || (Common.Utility.GetReactivityPhaseTextFromCode(_drWeakD[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.C37)==-1)))||
					((col == 5) && (!(bool)this._drWeakD[ARTIFICIAL.DAHGSave] || (Common.Utility.GetReactivityPhaseTextFromCode(_drWeakD[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.AHG)==-1)))||
					((col == 6) && (!(bool)this._drWeakD[ARTIFICIAL.DcAHGSave] || (Common.Utility.GetReactivityPhaseTextFromCode(_drWeakD[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.AHG)==-1)))||
					((col == 7) && (!(bool)this._drWeakD[ARTIFICIAL.DCCSave] || (Common.Utility.GetReactivityPhaseTextFromCode(_drWeakD[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.AHG)==-1)))||
					((col == 8) && (!(bool)this._drWeakD[ARTIFICIAL.DcCCSave] || (Common.Utility.GetReactivityPhaseTextFromCode(_drWeakD[TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.AHG)==-1)))||
					((col == 9) && (!(bool)this._drWeakD[ARTIFICIAL.InterpSave])))
				{
					this.dgWeakD.FindNextCell();
					//return;
				}
				else
				{
					//
					SetValidWeakDEntries(col);
				}
				//
				if (onCurrentCellChanged != null)
				{
					onCurrentCellChanged(sender,e);
				}
				//
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		#endregion

		#region Check Valid

		/// <summary>
		/// CheckValid
		/// </summary>
		/// <param name="errorMessage"></param>
		/// <returns></returns>
		public bool CheckValid(ref string errorMessage)
		{
			bool valid = true;
			errorMessage = string.Empty;
			//
			if (dgControl.DataSource != null)
			{
				if (((DataView)dgControl.DataSource).Table.Rows.Count>1)
				{
					DataRow drPos = ((DataView)dgControl.DataSource).Table.Rows[0];
					DataRow drNeg = ((DataView)dgControl.DataSource).Table.Rows[1];
					if ((drPos[ARTIFICIAL.Indicator].ToString() == "E") || (drNeg[ARTIFICIAL.Indicator].ToString() == "E"))
					{
						valid = false;
						errorMessage = errorMessage + Common.StrRes.Tooltips.UC041.InvalidQCResults().ResString + "\n";
					}
					if (((Guid)drPos[ARTIFICIAL.ControlReagentGuid] == Guid.Empty) || ((Guid)drNeg[ARTIFICIAL.ControlReagentGuid] == Guid.Empty))
					{
						valid = false;
						errorMessage = errorMessage + Common.StrRes.Tooltips.UC041.EnterLotNumbers().ResString + "\n";
					}
					if ((drPos[ARTIFICIAL.VialId].ToString() == string.Empty)||(drNeg[ARTIFICIAL.VialId].ToString() == string.Empty))
					{
						valid = false;
						errorMessage = errorMessage + Common.StrRes.Tooltips.UC041.EnterVialIdentifiers().ResString + "\n";
					}
					if (drPos[ARTIFICIAL.ControlInterp].ToString() == "N")
					{
						valid = false;
						errorMessage = errorMessage + Common.StrRes.Tooltips.UC041.InvalidPosControlInterp().ResString + "\n";
					}
					if (drNeg[ARTIFICIAL.ControlInterp].ToString() == "P")
					{
						valid = false;
						errorMessage = errorMessage + Common.StrRes.Tooltips.UC041.InvalidNegControlInterp().ResString + "\n";
					}
				}
			}
			//
			if (dgPhenotype.DataSource != null)
			{
				foreach(DataRow dr in ((DataView)dgPhenotype.DataSource).Table.Rows)
				{
					if (dr[ARTIFICIAL.Indicator].ToString() == "E")
					{
						valid = false;
						errorMessage = errorMessage + Common.StrRes.Tooltips.UC041.InvalidAntigenTyping().ResString + "\n";
						break;
					}
				}
			}
			//
			if (dgWeakD.DataSource != null)
			{
				foreach(DataRow dr in ((DataView)dgWeakD.DataSource).Table.Rows)
				{
					if (dr[ARTIFICIAL.Indicator].ToString() == "E")
					{
						valid = false;
						errorMessage = errorMessage + Common.StrRes.Tooltips.UC041.InvalidAntigenTyping().ResString + "\n";
						break;
					}
				}
			}
			//
			return valid;
		}

		#endregion

		#region Lot Number Event Handlers

		private void cmbLotNumber_KeyDown(object sender, KeyEventArgs e)
		{
			try
			{
				if (e.KeyCode == Keys.Enter)
				{
					//cmbLotNumber_SelectedIndexChanged(sender, e);
					this.dgControl.Direction = GridDirection.Down;
					this.dgControl.FindNextCell();
					cmbLotNumber.Hide();
					e.Handled = true;
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		/// <summary>
		/// QC Lot Number
		/// Implements BR_41.06
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbLotNumber_TextChanged(object sender, System.EventArgs e)
		{
			try
			{
				this.OnUserActivity();

				int row = this.dgControl.CurrentCell.RowNumber;
				int column = this.dgControl.CurrentCell.ColumnNumber;
				//
				DataTable dt = ((DataView)this.dgControl.DataSource).Table;
				//
				if ((bool)dt.Rows[row][ARTIFICIAL.PartiallyCompleted] == false)
				{
					DataRow[] drReagent;
					if (row == 0)
					{
                        // CR2814: Add an escape character so queries with single quotes don't crash.
                        drReagent = this._dtPosReagents.Select(TABLE.Reagent.LotNumber + " = '" + cmbLotNumber.Text.ToString().Replace("'", "''") + "'");
					}
					else
					{
                        // CR2814: Add an escape character so queries with single quotes don't crash.
						drReagent = this._dtNegReagents.Select(TABLE.Reagent.LotNumber + " = '" + cmbLotNumber.Text.ToString().Replace("'", "''") + "'");
					}
					//
					if ((drReagent != null)&&(drReagent.Length>0))
					{
						//
						if (Convert.ToDateTime(drReagent[0][TABLE.Reagent.LotExpirationDate]) < this.TestingDate)
						{
							if (((Guid)dt.Rows[row][ARTIFICIAL.ControlReagentGuid] != (Guid)drReagent[0][TABLE.Reagent.ReagentGuid])||dt.Rows[row].IsNull(ARTIFICIAL.OverrideComment))
							{
								DlgOverrideComment dlg = new DlgOverrideComment("Expired Antiserum",Common.StrRes.Tooltips.UC041.ExpiredAntiserum(drReagent[0][TABLE.ReagentType.ReagentTypeName].ToString()).ResString,"UT");

                                VbecsBaseForm tmpParent = (VbecsBaseForm)this.FindForm();
                                dlg.ShowDialogFromLockedParent(tmpParent, false);

								if (dlg.DialogResult !=DialogResult.OK)
								{
									//BR_41.06
									cmbLotNumber.SelectedIndex = -1;
									dt.Rows[row][TABLE.Reagent.LotNumber] = string.Empty;
									dt.Rows[row][TABLE.Reagent.LotExpirationDate] = DBNull.Value;
									dt.Rows[row][TABLE.Reagent.ReagentManufacturerName] = DBNull.Value;
									dt.Rows[row][ARTIFICIAL.ControlReagentGuid] = Guid.Empty;
									dt.Rows[row][ARTIFICIAL.OverrideComment] = DBNull.Value;
									return;
								}
								dt.Rows[row][ARTIFICIAL.OverrideComment] = dlg.Comment;
							}
						}
						else
						{
							dt.Rows[row][ARTIFICIAL.OverrideComment] = DBNull.Value;
						}
						//
						dt.Rows[row][TABLE.Reagent.LotNumber] = drReagent[0][TABLE.Reagent.LotNumber];
						dt.Rows[row][TABLE.Reagent.LotExpirationDate] = drReagent[0][TABLE.Reagent.LotExpirationDate];
						dt.Rows[row][TABLE.Reagent.ReagentManufacturerName] = drReagent[0][TABLE.Reagent.ReagentManufacturerName];
						dt.Rows[row][ARTIFICIAL.ControlReagentGuid] = drReagent[0][TABLE.Reagent.ReagentGuid];
					}
					else
					{
						dt.Rows[row][TABLE.Reagent.LotNumber] = string.Empty;
						dt.Rows[row][TABLE.Reagent.LotExpirationDate] = DBNull.Value;
						dt.Rows[row][TABLE.Reagent.ReagentManufacturerName] = DBNull.Value;
						dt.Rows[row][ARTIFICIAL.ControlReagentGuid] = Guid.Empty;
						dt.Rows[row][ARTIFICIAL.OverrideComment] = DBNull.Value;
					}
					//
					DisplayLotInformation((Guid)dt.Rows[row][ARTIFICIAL.ControlReagentGuid]);
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		#endregion

		#region Reagent Type Event Handlers

		private void cmbReagentType_KeyDown(object sender, KeyEventArgs e)
		{
			try
			{
				if (e.KeyCode == Keys.Enter)
				{
					//cmbReagentType_SelectedIndexChanged(sender, e);
					this.dgControl.Direction = GridDirection.Down;
					this.dgControl.FindNextCell();
					cmbReagentType.Hide();
					e.Handled = true;
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		private void cmbReagentType_TextChanged(object sener, EventArgs e)
		{
			try
			{
			this.OnUserActivity();

			int posID = this._posReagentTypeID;
			int negID = this._negReagentTypeID;
			//
			DataTable dt = ((DataView)this.dgControl.DataSource).Table;
			//
			int row = this.dgControl.CurrentCell.RowNumber;
			int column = this.dgControl.CurrentCell.ColumnNumber;
			//
				if ((bool)dt.Rows[row][ARTIFICIAL.PartiallyCompleted] == false)
				{
					DataRow[] drReagentType = this._dtReagentTypes.Select(TABLE.ReagentType.ReagentTypeName+" = '" + cmbReagentType.Text.ToString() + "'");
					if ((drReagentType != null)&&(drReagentType.Length>0))
					{
						if (row == 0)
						{
							this._posReagentTypeID = Convert.ToInt32(drReagentType[0][TABLE.ReagentType.ReagentTypeId]);
						}
						else
						{
							this._negReagentTypeID = Convert.ToInt32(drReagentType[0][TABLE.ReagentType.ReagentTypeId]);
						}
						//
						dt.Rows[row][ARTIFICIAL.ReagentType] = drReagentType[0][TABLE.ReagentType.ReagentTypeName];
						dt.Rows[row][TABLE.ReagentTestParameter.TestWithId] = Convert.ToInt32(drReagentType[0][TABLE.ReagentType.ReagentTypeId]);
					}
					else
					{
						if (row == 0)
						{
							this._posReagentTypeID = -1;
						}
						else
						{
							this._negReagentTypeID = -1;
						}
						//
						dt.Rows[row][ARTIFICIAL.ReagentType] = string.Empty;
						dt.Rows[row][TABLE.ReagentTestParameter.TestWithId] = DBNull.Value;
					}
					//
					//CR 2864 - prevents the wipeout of lot number when user is switching between tabs
					if (!this._userSwitchingTabs)
					{
						if (((row == 0) && (posID != this._posReagentTypeID))||((row == 1) && (negID != this._negReagentTypeID)))
						{
							dt.Rows[row][TABLE.Reagent.LotNumber] = string.Empty;
							dt.Rows[row][TABLE.Reagent.LotExpirationDate] = DBNull.Value;
							dt.Rows[row][TABLE.Reagent.ReagentManufacturerName] = DBNull.Value;
							dt.Rows[row][ARTIFICIAL.ControlReagentGuid] = Guid.Empty;
							dt.Rows[row][ARTIFICIAL.OverrideComment] = DBNull.Value;
						}
					}
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		#endregion

		#region Comment Event Handlers

		private void cmbControlComment_KeyDown(object sender, KeyEventArgs e)
		{
			try
			{
				if (e.KeyCode == Keys.Enter)
				{
					this.dgControl.Direction = GridDirection.Down;
					this.dgControl.FindNextCell();
					cmbControlComment.Hide();
					e.Handled = true;
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		/// <summary>
		/// Unit Antigen Typing QC test comment
		/// Implements BR_2.40
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbControlComment_TextChanged(object sender, System.EventArgs e)
		{
			try
			{
				this.OnUserActivity();

				int row = this.dgControl.CurrentCell.RowNumber;
				int column = this.dgControl.CurrentCell.ColumnNumber;
				//			//
				//			DataRow drReagentType = this._dtReagentTypes.Select("ReagentTypeName='" + cmbReagentType.SelectedItem.ToString() + "'")[0];
				//
				DataTable dt = ((DataView)this.dgControl.DataSource).Table;
				//
				dt.Rows[row][ARTIFICIAL.ControlComment] = cmbControlComment.Text;//drReagentType[TABLE.ReagentType.ReagentTypeName];
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		private void cmbComment_KeyDown(object sender, KeyEventArgs e)
		{
			try
			{
				if (e.KeyCode == Keys.Enter)
				{
					this.dgPhenotype.Direction = GridDirection.Down;
					this.dgPhenotype.FindNextCell();
					cmbComment.Hide();
					e.Handled = true;
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		/// <summary>
		/// Unit Antigen Typing test comment
		/// Implements BR_2.40
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbComment_TextChanged(object sender, System.EventArgs e)
		{
			try
			{
				this.OnUserActivity();

				int row = this.dgPhenotype.CurrentCell.RowNumber;
				int column = this.dgPhenotype.CurrentCell.ColumnNumber;
				//			//
				//			DataRow drReagentType = this._dtReagentTypes.Select("ReagentTypeName='" + cmbReagentType.SelectedItem.ToString() + "'")[0];
				//
				DataTable dt = ((DataView)this.dgPhenotype.DataSource).Table;
				//
				dt.Rows[row][ARTIFICIAL.Comment] = cmbComment.Text;//drReagentType[TABLE.ReagentType.ReagentTypeName];
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		private void cmbWeakDComment_KeyDown(object sender, KeyEventArgs e)
		{
			try
			{
				if (e.KeyCode == Keys.Enter)
				{
					this.dgWeakD.Direction = GridDirection.Down;
					this.dgWeakD.FindNextCell();
					cmbWeakDComment.Hide();
					e.Handled = true;
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		/// <summary>
		/// Unit Weak D Typing test comment
		/// Implements BR_2.40
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbWeakDComment_TextChanged(object sender, System.EventArgs e)
		{
			try
			{
				this.OnUserActivity();

				int row = this.dgWeakD.CurrentCell.RowNumber;
				int column = this.dgWeakD.CurrentCell.ColumnNumber;
				//			//
				//			DataRow drReagentType = this._dtReagentTypes.Select("ReagentTypeName='" + cmbReagentType.SelectedItem.ToString() + "'")[0];
				//
				DataTable dt = ((DataView)this.dgWeakD.DataSource).Table;
				//
				dt.Rows[row][ARTIFICIAL.Comment] = cmbWeakDComment.Text;//drReagentType[TABLE.ReagentType.ReagentTypeName];
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		#endregion

		#region Display Lot Information

		/// <summary>
		/// Display QC reagent info
		/// Implements BR_41.13
		/// </summary>
		/// <param name="reagentGuid"></param>
		private void DisplayLotInformation(Guid reagentGuid)
		{
			if (reagentGuid != Guid.Empty)
			{
				BOL.Reagent reagent = new BOL.Reagent(reagentGuid);
				this.txtLotNumber.Text = reagent.LotNumber;
				this.txtExpires.Text = Common.VBECSDateTime.FormatDateTimeString(reagent.LotExpirationDate);
				this.txtManufacturer.Text = reagent.ReagentManufacturerName;
			}
			else
			{
				this.txtLotNumber.Text = string.Empty;
				this.txtExpires.Text = string.Empty;
				this.txtManufacturer.Text = string.Empty;
			}
		}

		#endregion

		#region Invalidate Test Results

		/// <summary>
		/// Clears the test results from the grid. Restores datagrid to the initial status.
		/// </summary>
		public void ClearTestResults()
		{
			DataTable dtPhenotype = ((DataView)this.dgPhenotype.DataSource).Table;
			DataTable dtControl = ((DataView)this.dgControl.DataSource).Table;
			DataTable dtWeakD = ((DataView)this.dgWeakD.DataSource).Table;
			//
			if (dtPhenotype.Rows.Count > 0)
			{
				foreach(DataRow drPhenotype in dtPhenotype.Rows)
				{
					drPhenotype[ARTIFICIAL.Indicator] = string.Empty;
					drPhenotype[ARTIFICIAL.IS] = string.Empty;
					drPhenotype[ARTIFICIAL.RT] = string.Empty;
					drPhenotype[ARTIFICIAL.C37] = string.Empty;
					drPhenotype[ARTIFICIAL.AHG] = string.Empty;
					drPhenotype[ARTIFICIAL.CC] = string.Empty;
					drPhenotype[ARTIFICIAL.Interp] = string.Empty;
					drPhenotype[ARTIFICIAL.Comment] = string.Empty;
					drPhenotype[TABLE.ValidRhResult.SystemInterp] = string.Empty;
					drPhenotype[ARTIFICIAL.PartiallyCompleted] = false;
					drPhenotype[ARTIFICIAL.ISGuid] = Guid.NewGuid();
					drPhenotype[ARTIFICIAL.RTGuid] = Guid.NewGuid();
					drPhenotype[ARTIFICIAL.C37Guid] = Guid.NewGuid();
					drPhenotype[ARTIFICIAL.AHGGuid] = Guid.NewGuid();
					drPhenotype[ARTIFICIAL.CCGuid] = Guid.NewGuid();
					drPhenotype[ARTIFICIAL.InterpGuid] = Guid.NewGuid();
					drPhenotype[ARTIFICIAL.ISSave] = true;
					drPhenotype[ARTIFICIAL.RTSave] = true;
					drPhenotype[ARTIFICIAL.C37Save] = true;
					drPhenotype[ARTIFICIAL.AHGSave] = true;
					drPhenotype[ARTIFICIAL.CCSave] = true;
					drPhenotype[ARTIFICIAL.InterpSave] = true;
				}
			}
			//
			if (dtControl.Rows.Count > 0)
			{
				foreach(DataRow drControl in dtControl.Rows)
				{
					drControl[ARTIFICIAL.Indicator] = string.Empty;
					drControl[ARTIFICIAL.VialId] = string.Empty;
					drControl[TABLE.Reagent.LotNumber] = string.Empty;
					drControl[ARTIFICIAL.ReagentType] = string.Empty;
					drControl[ARTIFICIAL.ControlReagentGuid] = Guid.NewGuid();
					drControl[TABLE.Reagent.LotExpirationDate] = DateTime.MinValue;
					drControl[TABLE.Reagent.ReagentManufacturerName] = string.Empty;
					drControl[ARTIFICIAL.IS] = string.Empty;
					drControl[ARTIFICIAL.RT] = string.Empty;
					drControl[ARTIFICIAL.C37] = string.Empty;
					drControl[ARTIFICIAL.AHG] = string.Empty;
					drControl[ARTIFICIAL.CC] = string.Empty;
					drControl[ARTIFICIAL.ControlInterp] = string.Empty;
					drControl[ARTIFICIAL.ControlComment] = string.Empty;
					drControl[ARTIFICIAL.SystemControlInterp] = string.Empty;
					drControl[ARTIFICIAL.PartiallyCompleted] = false;
					drControl[ARTIFICIAL.ISGuid] = Guid.NewGuid();
					drControl[ARTIFICIAL.RTGuid] = Guid.NewGuid();
					drControl[ARTIFICIAL.C37Guid] = Guid.NewGuid();
					drControl[ARTIFICIAL.AHGGuid] = Guid.NewGuid();
					drControl[ARTIFICIAL.CCGuid] = Guid.NewGuid();
					drControl[ARTIFICIAL.ControlInterpGuid] = Guid.NewGuid();
					drControl[ARTIFICIAL.ISSave] = true;
					drControl[ARTIFICIAL.RTSave] = true;
					drControl[ARTIFICIAL.C37Save] = true;
					drControl[ARTIFICIAL.AHGSave] = true;
					drControl[ARTIFICIAL.CCSave] = true;
					drControl[ARTIFICIAL.ControlInterpSave] = true;
				}
			}
			//
			if (dtWeakD.Rows.Count > 0)
			{
				foreach(DataRow drWeakD in dtWeakD.Rows)
				{
					drWeakD[ARTIFICIAL.Indicator] = string.Empty;
					drWeakD[ARTIFICIAL.D37] = string.Empty;
					drWeakD[ARTIFICIAL.Dc37] = string.Empty;
					drWeakD[ARTIFICIAL.DAHG] = string.Empty;
					drWeakD[ARTIFICIAL.DcAHG] = string.Empty;
					drWeakD[ARTIFICIAL.DCC] = string.Empty;
					drWeakD[ARTIFICIAL.DcCC] = string.Empty;
					drWeakD[ARTIFICIAL.Interp] = string.Empty;
					drWeakD[ARTIFICIAL.Comment] = string.Empty;
					drWeakD[TABLE.ValidRhResult.SystemInterp] = string.Empty;
					drWeakD[ARTIFICIAL.PartiallyCompleted] = false;
					drWeakD[ARTIFICIAL.D37Guid] = Guid.NewGuid();
					drWeakD[ARTIFICIAL.Dc37Guid] = Guid.NewGuid();
					drWeakD[ARTIFICIAL.DAHGGuid] = Guid.NewGuid();
					drWeakD[ARTIFICIAL.DcAHGGuid] = Guid.NewGuid();
					drWeakD[ARTIFICIAL.DCCGuid] = Guid.NewGuid();
					drWeakD[ARTIFICIAL.DcCCGuid] = Guid.NewGuid();
					drWeakD[ARTIFICIAL.InterpGuid] = Guid.NewGuid();
					drWeakD[ARTIFICIAL.D37Save] = true;
					drWeakD[ARTIFICIAL.Dc37Save] = true;
					drWeakD[ARTIFICIAL.DAHGSave] = true;
					drWeakD[ARTIFICIAL.DcAHGSave] = true;
					drWeakD[ARTIFICIAL.DCCSave] = true;
					drWeakD[ARTIFICIAL.DcCCSave] = true;
					drWeakD[ARTIFICIAL.InterpSave] = true;
				}
			}
		}

		#endregion

		/// <summary>
		/// FocusPhenotypeGrid
		/// </summary>
		public void FocusPhenotypeGrid()
		{
			if ((this.dgControl.DataSource!= null)&&(((DataView)this.dgControl.DataSource).Table.Rows.Count>0))
			{
				this.dgControl.Focus();
				this.dgControl.SetCurrentCell(0,1);
			}
			else
			{
				this.dgPhenotype.Focus();
				this.dgPhenotype.SetCurrentCell(0,1);
			}
		}

		/// <summary>
		/// FocusWeakDGrid
		/// </summary>
		public void FocusWeakDGrid()
		{
			//CR 2836 CR 2724
			this.dgWeakD.Focus();
			this.dgWeakD.SetCurrentCell(0, 1);
		}

		private void btnInvalidateResults_MouseHover(object sender, System.EventArgs e)
		{
			try
			{
				this.ttToolTip.SetToolTip(this.btnInvalidateResults,Common.StrRes.Tooltips.Common.InvalidateTestResults().ResString);
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		private void dgPhenotype_LostFocus(object sender, EventArgs e)
		{
			try
			{
				if (e.GetType().FullName == typeof(VbecsGridEventArgs).FullName)
				{
					if (((VbecsGridEventArgs)e).TabKeyPressed)
					{
						//this.InvokeLostFocus(this,e);
						//this.btnInvalidateResults.Focus();
						this.SelectNextControl(this.dgPhenotype,true,true,false,false);
					}
					else
					{
						this.dgControl.Focus();
						this.dgControl.SetCurrentCell(this.dgControl.CurrentCell.RowNumber,this.dgControl.CurrentCell.ColumnNumber);
					}
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		private void dgControl_LostFocus(object sender, EventArgs e)
		{
			try
			{
				if (e.GetType().FullName == typeof(VbecsGridEventArgs).FullName)
				{
					if (((VbecsGridEventArgs)e).TabKeyPressed)
					{
						//this.InvokeLostFocus(this,e);
						//this.btnInvalidateResults.Focus();
						this.SelectNextControl(this.dgPhenotype,true,true,false,false);
					}
					else
					{
						this.dgPhenotype.Focus();
						this.dgPhenotype.SetCurrentCell(this.dgPhenotype.CurrentCell.RowNumber,this.dgPhenotype.CurrentCell.ColumnNumber);
					}
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		private void dgWeakD_Enter(object sender, System.EventArgs e)
		{
			//this.dgWeakD.SetCurrentCell(0,1);
			//this.dgWeakD.SetNoCurrentCell();
		}

		private void dgControl_Resize(object sender, System.EventArgs e)
		{
			try
			{
				DataGridTableStyle tblStyle = this.dgControl.TableStyles[ARTIFICIAL.Control];
				// 3554
			    if (tblStyle != null)
			    {
			        tblStyle.GridColumnStyles[ARTIFICIAL.ControlComment].Width = this.dgControl.Width -
			                                                                     (tblStyle.GridColumnStyles[ARTIFICIAL.Indicator].Width +
			                                                                      tblStyle.GridColumnStyles[ARTIFICIAL.Control].Width +
			                                                                      tblStyle.GridColumnStyles[ARTIFICIAL.ReagentType].Width +
			                                                                      tblStyle.GridColumnStyles[TABLE.Reagent.LotNumber].Width +
			                                                                      tblStyle.GridColumnStyles[ARTIFICIAL.VialId].Width +
			                                                                      tblStyle.GridColumnStyles[ARTIFICIAL.IS].Width +
			                                                                      tblStyle.GridColumnStyles[ARTIFICIAL.RT].Width +
			                                                                      tblStyle.GridColumnStyles[ARTIFICIAL.C37].Width +
			                                                                      tblStyle.GridColumnStyles[ARTIFICIAL.AHG].Width +
			                                                                      tblStyle.GridColumnStyles[ARTIFICIAL.CC].Width +
			                                                                      tblStyle.GridColumnStyles[ARTIFICIAL.ControlInterp].Width + 5);
			        this.cmbControlComment.Width = tblStyle.GridColumnStyles[ARTIFICIAL.ControlComment].Width;
			    }
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		private void dgPhenotype_Resize(object sender, System.EventArgs e)
		{
			try
			{
				DataGridTableStyle tblStyle = this.dgPhenotype.TableStyles["Phenotype"];
				// CR 3554
			    if (tblStyle != null)
			    {
			        tblStyle.GridColumnStyles[ARTIFICIAL.Comment].Width = this.dgPhenotype.Width -
			                                                              (tblStyle.GridColumnStyles[ARTIFICIAL.Indicator].Width +
			                                                               tblStyle.GridColumnStyles[TABLE.ExceptionAntigenTest.UnitId].Width +
			                                                               tblStyle.GridColumnStyles[TABLE.BloodProduct.ProductName].Width +
			                                                               tblStyle.GridColumnStyles[ARTIFICIAL.IS].Width +
			                                                               tblStyle.GridColumnStyles[ARTIFICIAL.RT].Width +
			                                                               tblStyle.GridColumnStyles[ARTIFICIAL.C37].Width +
			                                                               tblStyle.GridColumnStyles[ARTIFICIAL.AHG].Width +
			                                                               tblStyle.GridColumnStyles[ARTIFICIAL.CC].Width +
			                                                               tblStyle.GridColumnStyles[ARTIFICIAL.Interp].Width + 5);
			        this.cmbComment.Width = tblStyle.GridColumnStyles[ARTIFICIAL.Comment].Width;
			    }
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		private void dgWeakD_Resize(object sender, System.EventArgs e)
		{
			try
			{
				DataGridTableStyle tblStyle = this.dgWeakD.TableStyles["WeakD"];
				// CR 3554
			    if (tblStyle != null)
			    {
			        tblStyle.GridColumnStyles[ARTIFICIAL.Comment].Width = this.dgWeakD.Width -
			                                                              (tblStyle.GridColumnStyles[ARTIFICIAL.Indicator].Width +
			                                                               tblStyle.GridColumnStyles[TABLE.ExceptionAntigenTest.UnitId].Width +
			                                                               tblStyle.GridColumnStyles[TABLE.BloodProduct.ProductName].Width +
			                                                               tblStyle.GridColumnStyles[ARTIFICIAL.D37].Width +
			                                                               tblStyle.GridColumnStyles[ARTIFICIAL.Dc37].Width +
			                                                               tblStyle.GridColumnStyles[ARTIFICIAL.DAHG].Width +
			                                                               tblStyle.GridColumnStyles[ARTIFICIAL.DcAHG].Width +
			                                                               tblStyle.GridColumnStyles[ARTIFICIAL.DCC].Width +
			                                                               tblStyle.GridColumnStyles[ARTIFICIAL.DcCC].Width +
			                                                               tblStyle.GridColumnStyles[ARTIFICIAL.Interp].Width + 5);
			        this.cmbWeakDComment.Width = tblStyle.GridColumnStyles[ARTIFICIAL.Comment].Width;
			    }
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		private void dgWeakD_LostFocus(object sender, EventArgs e)
		{
			try
			{
				if (e.GetType().FullName == typeof(VbecsGridEventArgs).FullName)
				{
					if (((VbecsGridEventArgs)e).TabKeyPressed)
					{
						//this.InvokeLostFocus(this,e);
						this.SelectNextControl(this.dgWeakD,true,true,false,false);
					}
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}
	}

	#region Phenotype Control Data Grid

	/// <summary>
	/// Class PhenotypeControlDataGrid
	/// </summary>
	public class PhenotypeControlDataGrid : AntigenTypingDataGrid
	{
		private const int WM_KEYDOWN = 256;		//0x100;
		//
		private gov.va.med.vbecs.GUI.controls.PhenotypeDataGrid _phenotypeDataGrid;

		/// <summary>
		/// Constructor
		/// </summary>
		public PhenotypeControlDataGrid() : base()
		{
		}

		/// <summary>
		/// Get/Set PhenotypeDataGrid
		/// </summary>
		public gov.va.med.vbecs.GUI.controls.PhenotypeDataGrid PhenotypeDataGrid
		{
			get
			{
				return this._phenotypeDataGrid;
			}
			set
			{
				this._phenotypeDataGrid = value;
			}
		}  

		/// <summary>
		/// ProcessKeyPreview
		/// </summary>
		/// <param name="msg"></param>
		/// <returns></returns>
		protected override bool ProcessKeyPreview(ref Message msg)
		{	
			try
			{
				if(msg.Msg == WM_KEYDOWN) 
				{
					//Combo box column should not move cells on Up or Down arrow...
					if ((this.TableStyles[0].GridColumnStyles[this.CurrentCell.ColumnNumber].GetType().FullName == typeof(DataGridTextBoxColumn).FullName) && (((DataGridTextBoxColumn)this.TableStyles[0].GridColumnStyles[this.CurrentCell.ColumnNumber]).TextBox.Controls.Count>0))
					{
						if ((msg.WParam.ToInt32()==(int)Keys.Up)||(msg.WParam.ToInt32()==(int)Keys.Down))
						{
							return false;
						}
						if ((msg.WParam.ToInt32()==(int)Keys.Right)&&(this.CurrentCell.ColumnNumber > 10))
						{
							return false;
						}
						//BR_2.31
						if (msg.WParam.ToInt32() == (int)Keys.Return)
						{
							this.Direction = GridDirection.Down;
							FindNextCell();
							return true;
						}
						if ((msg.WParam.ToInt32() == (int)Keys.PageDown) && (this.CurrentCell.RowNumber == (this.VisibleRowCount-1)))
						{
							this.Direction = GridDirection.Down;
							FindNextCell();
							return true;
						}
						if ((msg.WParam.ToInt32() == (int)Keys.PageUp) && (this.CurrentCell.RowNumber == 0))
						{
							this.Direction = GridDirection.Up;
							FindNextCell();
							return true;
						}
					}
					if (((msg.WParam.ToInt32() == (int)Keys.Down)||(msg.WParam.ToInt32() == (int)Keys.PageDown)) && (this.CurrentCell.RowNumber == (this.VisibleRowCount-1)))
					{
						this.Direction = GridDirection.Down;
						FindNextCell();
						return true;
					}
					if (((msg.WParam.ToInt32() == (int)Keys.Up)||(msg.WParam.ToInt32() == (int)Keys.PageUp)) && (this.CurrentCell.RowNumber == 0))
					{
						this.Direction = GridDirection.Up;
						FindNextCell();
						return true;
					}
				}
				return base.ProcessKeyPreview(ref msg);
			}
			catch(ObjectDisposedException)
			{
				return(true);
				/*swallow the ObjectDisposedException ocurring on a lock expiration*/
			}
		}

		/// <summary>
		/// Find Next available cell
		/// Implements BR_2.29
		/// </summary>
		public override void FindNextCell()
		{
			int row = this.CurrentCell.RowNumber;
			int col = this.CurrentCell.ColumnNumber;
			int maxRow = ((DataView)this.PhenotypeDataGrid.DataSource).Table.Rows.Count -1;
			//
			if (this.Direction == GridDirection.Right)
			{
				if (col < 12)
				{
					this.SetCurrentCell(row,col+1);
				}
				else
				{
					this.SetCurrentCell(row,col);
				}
			}
			else if (this.Direction == GridDirection.Left)
			{
				if (col > 2)
				{
					this.SetCurrentCell(row,col-1);
				}
				else
				{
					this.SetCurrentCell(row,col);
				}
			}
			else if (this.Direction == GridDirection.Down)
			{
				if (row == 0)
				{
					this.SetCurrentCell(row+1,col);
				}
				else
				{
					if (col>4)
					{
						this.SetNoCurrentCell();
						this.OnLeave(EventArgs.Empty);
						this.PhenotypeDataGrid.Direction = this.Direction;
						//this.InvokeLostFocus(this,new VbecsGridEventArgs(false));
						this.PhenotypeDataGrid.SetCurrentCell(0,col-2);
					}
					else
					{
						this.SetCurrentCell(0,col+1);
					}
				}
			}
			else if (this.Direction == GridDirection.Up)
			{
				if (row >0)
				{
					this.SetCurrentCell(row-1,col);
				}
				else 
				{
					if (col>5)
					{
						this.SetNoCurrentCell();
						this.OnLeave(EventArgs.Empty);
						this.PhenotypeDataGrid.Direction = this.Direction;
						this.PhenotypeDataGrid.SetCurrentCell(maxRow,col-3);
					}
					else if (col>2)
					{
						this.SetCurrentCell(1,col-1);
					}
					else
					{
						this.SetCurrentCell(row,col);
					}
				}
			}
			//
			if (this.CurrentCell.ColumnNumber == 0)
			{
				this.SetCurrentCell(row,1);
			}
		}
	}

	#endregion

	#region Phenotype Data Grid

	/// <summary>
	/// Class PhenotypeDataGrid
	/// </summary>
	public class PhenotypeDataGrid : AntigenTypingDataGrid
	{
		private const int WM_KEYDOWN = 256;		//0x100;
		//
		private gov.va.med.vbecs.GUI.controls.PhenotypeControlDataGrid _phenotypeControlDataGrid;

		/// <summary>
		/// Constrcutor
		/// </summary>
		public PhenotypeDataGrid() : base()
		{
		}

		/// <summary>
		/// Get/Set PhenotypeControlDataGrid
		/// </summary>
		public gov.va.med.vbecs.GUI.controls.PhenotypeControlDataGrid PhenotypeControlDataGrid
		{
			get
			{
				return this._phenotypeControlDataGrid;
			}
			set
			{
				this._phenotypeControlDataGrid = value;
			}
		} 

		/// <summary>
		/// ProcessKeyPreview
		/// </summary>
		/// <param name="msg"></param>
		/// <returns></returns>
		protected override bool ProcessKeyPreview(ref Message msg)
		{	
			try
			{
				if(msg.Msg == WM_KEYDOWN) 
				{
					//Determine if system needs to move to control grid
					DataTable dtControl = ((DataView)this.PhenotypeControlDataGrid.DataSource).Table;
					DataTable dtPhenotype = ((DataView)this.DataSource).Table;
					//
					//Combo box column should not move cells on Up or Down arrow...
					if ((this.TableStyles[0].GridColumnStyles[this.CurrentCell.ColumnNumber].GetType().FullName == typeof(DataGridTextBoxColumn).FullName) && (((DataGridTextBoxColumn)this.TableStyles[0].GridColumnStyles[this.CurrentCell.ColumnNumber]).TextBox.Controls.Count>0))
					{
						if ((msg.WParam.ToInt32()==(int)Keys.Up)||(msg.WParam.ToInt32()==(int)Keys.Down))
						{
							return false;
						}
						if ((msg.WParam.ToInt32()==(int)Keys.Right)&&(this.CurrentCell.ColumnNumber > 8))
						{
							return false;
						}
						//BR_2.31
						if (msg.WParam.ToInt32() == (int)Keys.Return)
						{
							this.Direction = GridDirection.Down;
							FindNextCell();
							return true;
						}
						if ((msg.WParam.ToInt32() == (int)Keys.PageDown) && (this.CurrentCell.RowNumber == (this.VisibleRowCount-1)) && (dtControl.Rows.Count>0))
						{
							this.Direction = GridDirection.Down;
							FindNextCell();
							return true;
						}
						if ((msg.WParam.ToInt32() == (int)Keys.PageUp) && (this.CurrentCell.RowNumber == 0) && (dtControl.Rows.Count>0))
						{
							this.Direction = GridDirection.Up;
							FindNextCell();
							return true;
						}
					}
					if (dtControl.Rows.Count>0)
					{
						if (((msg.WParam.ToInt32() == (int)Keys.Down)||(msg.WParam.ToInt32() == (int)Keys.PageDown)) && (this.CurrentCell.RowNumber == (this.VisibleRowCount-1)))
						{
							this.Direction = GridDirection.Down;
							FindNextCell();
							return true;
						}
						if (((msg.WParam.ToInt32() == (int)Keys.Up)||(msg.WParam.ToInt32() == (int)Keys.PageUp)) && (this.CurrentCell.RowNumber == 0))
						{
							this.Direction = GridDirection.Up;
							FindNextCell();
							return true;
						}
					}
				}
				return base.ProcessKeyPreview(ref msg);
			}
			catch(ObjectDisposedException)
			{
				return(true);
				/*swallow the ObjectDisposedException ocurring on a lock expiration*/
			}
		}

		/// <summary>
		/// Find Next available cell
		/// Implements BR_2.29
		/// </summary>
		public override void FindNextCell()
		{
			int row = this.CurrentCell.RowNumber;
			int col = this.CurrentCell.ColumnNumber;
			int maxRow = ((DataView)this.DataSource).Table.Rows.Count -1;
			//
			if (this.Direction == GridDirection.Right)
			{
				if (col < 9)
				{
					this.SetCurrentCell(row,col+1);
				}
				else
				{
					this.SetCurrentCell(row,col);
				}
			}
			else if (this.Direction == GridDirection.Left)
			{
				if (col > 2)
				{
					this.SetCurrentCell(row,col-1);
				}
				else
				{
					this.SetCurrentCell(row,col);
				}
			}
			else if (this.Direction == GridDirection.Down)
			{
				if (row < maxRow)
				{
					this.SetCurrentCell(row+1,col);
				}
				else
				{
					if ((((DataView)this.PhenotypeControlDataGrid.DataSource).Table.Rows.Count>0))
					{
						if (col < 9)
						{
							this.SetNoCurrentCell();
							this.OnLeave(EventArgs.Empty);
							this.PhenotypeControlDataGrid.Direction = this.Direction;
							this.PhenotypeControlDataGrid.SetCurrentCell(0,col+3);
						}
						else
						{
							this.SetCurrentCell(row,col);
						}
					}
					else
					{
						if (col < 9)
						{
							this.SetCurrentCell(0,col+1);
						}
						else
						{
							this.SetCurrentCell(row,col);
						}
					}
				}
			}
			else if (this.Direction == GridDirection.Up)
			{
				if (row > 0)
				{
					this.SetCurrentCell(row-1,col);
				}
				else
				{
					if (((DataView)this.PhenotypeControlDataGrid.DataSource).Table.Rows.Count>0)
					{
						this.SetNoCurrentCell();
						this.OnLeave(EventArgs.Empty);
						this.PhenotypeControlDataGrid.Direction = this.Direction;
						this.PhenotypeControlDataGrid.SetCurrentCell(1,col+2);
					}
					else
					{
						if (col >3)
						{
							this.SetCurrentCell(maxRow,col-1);
						}
						else
						{
							this.SetCurrentCell(row,col);
						}
					}
				}
			}
			//
			if (this.CurrentCell.ColumnNumber == 0)
			{
				this.SetCurrentCell(row,1);
			}
		}
	}
	#endregion

	#region Weak D Data Grid

	/// <summary>
	/// Class WeakDDataGrid
	/// </summary>
	public class WeakDDataGrid : AntigenTypingDataGrid
	{
		private const int WM_KEYDOWN = 256;		//0x100;

		/// <summary>
		/// Constructor
		/// </summary>
		public WeakDDataGrid() : base()
		{
		}

		/// <summary>
		/// Implements BR_2.31
		/// </summary>
		/// <param name="msg"></param>
		/// <returns></returns>
		protected override bool ProcessKeyPreview(ref Message msg)
		{	
			try
			{
				if(msg.Msg == WM_KEYDOWN) 
				{
					//Combo box column should not move cells on Up or Down arrow...
					if ((this.TableStyles[0].GridColumnStyles[this.CurrentCell.ColumnNumber].GetType().FullName == typeof(DataGridTextBoxColumn).FullName) && (((DataGridTextBoxColumn)this.TableStyles[0].GridColumnStyles[this.CurrentCell.ColumnNumber]).TextBox.Controls.Count>0))
					{
						if ((msg.WParam.ToInt32()==(int)Keys.Up)||(msg.WParam.ToInt32()==(int)Keys.Down))
						{
							return false;
						}
						if ((msg.WParam.ToInt32()==(int)Keys.Right)&&(this.CurrentCell.ColumnNumber > 9))
						{
							return false;
						}
						//BR_2.31
						if (msg.WParam.ToInt32() == (int)Keys.Return)
						{
							this.Direction = GridDirection.Down;
							FindNextCell();
							return true;
						}
						if ((msg.WParam.ToInt32() == (int)Keys.PageDown) && (this.CurrentCell.RowNumber == (this.VisibleRowCount-1)))
						{
							this.Direction = GridDirection.Down;
							FindNextCell();
							return true;
						}
						if ((msg.WParam.ToInt32() == (int)Keys.PageUp) && (this.CurrentCell.RowNumber == 0))
						{
							this.Direction = GridDirection.Up;
							FindNextCell();
							return true;
						}
					}
					if (((msg.WParam.ToInt32() == (int)Keys.Down)||(msg.WParam.ToInt32() == (int)Keys.PageDown)) && (this.CurrentCell.RowNumber == (this.VisibleRowCount-1)))
					{
						this.Direction = GridDirection.Down;
						FindNextCell();
						return true;
					}
					if (((msg.WParam.ToInt32() == (int)Keys.Up)||(msg.WParam.ToInt32() == (int)Keys.PageUp)) && (this.CurrentCell.RowNumber == 0))
					{
						this.Direction = GridDirection.Up;
						FindNextCell();
						return true;
					}
				}
				return base.ProcessKeyPreview(ref msg);
			}
			catch(ObjectDisposedException)
			{
				return(true);
				/*swallow the ObjectDisposedException ocurring on a lock expiration*/
			}
		}

		/// <summary>
		/// Find Next available cell
		/// Implements BR_2.29
		/// </summary>
		public override void FindNextCell()
		{
			int row = this.CurrentCell.RowNumber;
			int col = this.CurrentCell.ColumnNumber;
			int maxRow = ((DataView)this.DataSource).Table.Rows.Count -1;
			//
			if (this.Direction == GridDirection.Right)
			{
				if (col < 10)
				{
					this.SetCurrentCell(row,col+1);
				}
				else
				{
					this.SetCurrentCell(row,col);
				}
			}
			else if (this.Direction == GridDirection.Left)
			{
				if (col > 2)
				{
					this.SetCurrentCell(row,col-1);
				}
				else
				{
					this.SetCurrentCell(row,col);
				}
			}
			else if (this.Direction == GridDirection.Down)
			{
				if (row < maxRow)
				{
					this.SetCurrentCell(row+1,col);
				}
				else
				{
					if (col < 10)
					{
						this.SetCurrentCell(0,col+1);
					}
					else
					{
						this.SetCurrentCell(row,col);
					}
				}
			}
			else if (this.Direction == GridDirection.Up)
			{
				if (row >0)
				{
					this.SetCurrentCell(row-1,col);
				}
				else 
				{
					if (col>2)
					{
						this.SetCurrentCell(1,col-1);
					}
					else
					{
						this.SetCurrentCell(row,col);
					}
				}
			}
			//
			if (this.CurrentCell.ColumnNumber == 0)
			{
				this.SetCurrentCell(row,1);
			}
		}
	}
	#endregion

	#region Antigen Typing Data Grid

	/// <summary>
	/// Class AntigenTypingDataGrid
	/// </summary>
	public abstract class AntigenTypingDataGrid : DataGrid
	{
		private int hitCol; 
		private int hitRow; 
		private bool _processAcross = true;
		private int _toolTipColumn = -1;
		private System.Windows.Forms.ToolTip toolTip1;
		private const int WM_LBUTTONDOWN = 513; // 0x0201 
		private const int WM_LBUTTONUP = 514;	// 0x0202 
		private const int WM_KEYDOWN = 256;		//0x100;
		private const int WM_KEYUP = 257;		//0x101;
		private bool _enterKeyPressed = false;	//CR 2792 this flag will be set to true if Enter key was pressed
		private static bool _onMouseDownFired = false; //CR 2792 this flag is used to prevent from OnMouseDown event from firing multiple times
		//
		private GridDirection _direction;

		/// <summary>
		/// Constructor
		/// </summary>
		public AntigenTypingDataGrid() : base()
		{
			hitCol = 0;
			hitRow = -1;

			this.toolTip1 = new System.Windows.Forms.ToolTip(); 
			this.toolTip1.InitialDelay = 250; 

			InitializeComponent();
		}

		#region Component Designer generated code

		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			((System.ComponentModel.ISupportInitialize)(this)).BeginInit();
			// 
			// AntigenTypingDataGrid
			// 
			this.AllowSorting = false;
			this.Anchor = (((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.CaptionFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.CaptionVisible = false;
			this.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.HeaderFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.RowHeadersVisible = false;
			this.Size = new System.Drawing.Size(760, 356);
			((System.ComponentModel.ISupportInitialize)(this)).EndInit();
		}

		#endregion

		/// <summary>
		/// Gets or sets whether the grid will be processed from left to right.  If this value is false
		/// the grid will be processed from top to bottom.
		/// </summary>
		public bool ProcessAcross
		{
			get
			{
				return _processAcross;
			}
			set 
			{
				_processAcross = value;
			}
		}

		/// <summary>
		///  Gets or sets the column where the tool tip resides.
		/// </summary>
		public int ToolTipColumn
		{
			get
			{
				return _toolTipColumn;
			}
			set 
			{
				_toolTipColumn = value;
			}
		}

		/// <summary>
		/// Get and set the value of Direction
		/// </summary>
		public GridDirection Direction
		{
			get
			{
				return _direction;
			}
			set
			{
				_direction = value;
			}
		}

		/// <summary>
		/// CR 2792
		/// </summary>
		public bool EnterKeyPressed
		{
			get
			{
				return this._enterKeyPressed;
			}
		}

		#region Methods 
 
		[System.Runtime.InteropServices.DllImport("user32.dll")] 
		static extern bool SendMessage(IntPtr hWnd, Int32 msg, Int32 wParam, Int32 lParam); 

		/// <summary>
		/// SetNoCurrentCell
		/// </summary>
		public void SetNoCurrentCell() 
		{ 
			//click on top left corner of the grid 
			SendMessage( this.Handle, WM_LBUTTONDOWN, 0, 0); 
			SendMessage( this.Handle, WM_LBUTTONUP, 0, 0); 
		} 

		/// <summary>
		/// SetCurrentCell
		/// </summary>
		/// <param name="row"></param>
		/// <param name="col"></param>
		public void SetCurrentCell(int row, int col)
		{
			this.Focus();
			this.CurrentCell = new DataGridCell(row,col);
			this.OnCurrentCellChanged(EventArgs.Empty);
		}

		#endregion

		/// <summary>
		/// FindNextCell
		/// </summary>
		public virtual void FindNextCell()
		{
		}

		/// <summary>
		/// This code prevents the sizing cursor from appearing in the datagrid.  It also 
		/// sets the tool tip for a row.
		/// Implements BR_2.37
		/// </summary>
		/// <param name="e"></param>
		protected override void OnMouseMove(MouseEventArgs e)  
		{ 
			try
			{
				DataGrid.HitTestInfo hti = this.HitTest(new Point(e.X, e.Y)); 
				if(hti.Type == DataGrid.HitTestType.ColumnResize) 
				{ 
					return;
				} 
				else
				{
					if(hti.Type == DataGrid.HitTestType.Cell)
					{
						//If someone doesn't like the way this is behaving now, this is what I changed
						//Added this if check to set the tooltip, because it wasn't refreshing consistantly
						//BR_2.37
						if (hti.Row > -1)
						{
							if (ToolTipColumn != -1)
								this.toolTip1.SetToolTip(this, this[hti.Row, ToolTipColumn].ToString()); 
						}
						if ( hti.Row != hitRow)
						{
							if (hti.Column == hitCol)
							{	
								if (ToolTipColumn != -1)
								{
									hitRow = hti.Row; 

									if(this.toolTip1 != null && this.toolTip1.Active) 
									{
										this.toolTip1.Active = false; 
									}

									//	CR 3554							
								    var toolTip = this.toolTip1;
								    if (toolTip != null) toolTip.Active = true;

								    return;
								}
							}
						}
					}
				}
				base.OnMouseMove(e); 
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		} 

		/// <summary>
		/// This code makes the enter key act like the tab key for comment cells.
		/// Implements BR_2.31
		/// </summary>
		/// <param name="msg"></param>
		/// <param name="keyData"></param>
		/// <returns></returns>
		protected override bool ProcessCmdKey(ref Message msg, Keys keyData) 
		{
			try
			{
				if (msg.WParam.ToInt32() == (int)Keys.Return)
				{
					//CR 2792
					this._enterKeyPressed = true;
					
					//If we're in a combo-box return means move to next combo-box, so we'll allow it
					//BR_2.31
					if (((DataGridTextBoxColumn)this.TableStyles[0].GridColumnStyles[this.CurrentCell.ColumnNumber]).TextBox.Controls.Count==0)
					{
						this.FindNextCell();
						return true;
					}
				}
				else if (msg.WParam.ToInt32() == (int)Keys.Tab)
				{
					//CR 2792
					this._enterKeyPressed = false;
					this.InvokeLostFocus(this,new VbecsGridEventArgs(true));				
					return true;
				}
				//
				//CR 2792
				this._enterKeyPressed = false;
				return base.ProcessCmdKey(ref msg, keyData);
			}
			catch(ObjectDisposedException)
			{
				return(true);
				/*swallow the ObjectDisposedException ocurring on a lock expiration*/
			}
		}  

		/// <summary>
		/// This code prevents allowing the user to resize the datagrid columns. 
		/// </summary>
		/// <param name="e"></param>
		protected override void OnMouseDown(MouseEventArgs e) 
		{
			//this code prevents OnMouseDown even from being fired multiple times on one mouse click
			//CR 2792
			if (_onMouseDownFired)
			{
				return;
			}

			try
			{
				DataGrid.HitTestInfo hti = this.HitTest(new Point(e.X, e.Y));
				//
				if (this._processAcross)
				{
					this._direction = GridDirection.Right;
				}
				else
				{
					this._direction = GridDirection.Down;
				}
				// 
				DataGridCell currentCell = this.CurrentCell;

				//CR 2792 if the user clicks on anything else besides the grid cell the event will be skipped and the cursor placed back on the cell
				if(hti.Type != DataGrid.HitTestType.Cell) 
				{ 
					//setting flag to stop TextChanged event from firing when forcing cursor back into the grid
					this._enterKeyPressed = true;

					this.CurrentCell = new DataGridCell(0,0);
					this.CurrentCell = new DataGridCell(currentCell.RowNumber, currentCell.ColumnNumber);

					this._enterKeyPressed = false;
					
					return;
				}
				//clicking mouse button on a cell in a different row causes the TextChanged event to be fired
				//setting a flag to prevent this from happening CR 2792
				this._enterKeyPressed = true;
				_onMouseDownFired = true;
				
				base.OnMouseDown(e); 

				_onMouseDownFired = false;
				this._enterKeyPressed = false;
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		} 

		/// <summary>
		/// ProcessKeyPreview
		/// </summary>
		/// <param name="msg"></param>
		/// <returns></returns>
		protected override bool ProcessKeyPreview(ref Message msg)
		{	
			try
			{
				if (msg.Msg == WM_KEYDOWN)
				{
					switch(msg.WParam.ToInt32())       
					{         
						case (int)Keys.Up:   
							this._direction = GridDirection.Up;
							break;                  
						case (int)Keys.Down:   
							this._direction = GridDirection.Down;
							break;
						case (int)Keys.Left:   
							this._direction = GridDirection.Left;
							break;
						case (int)Keys.Right:   
							this._direction = GridDirection.Right;
							break;
						default:
							if (this._processAcross)
							{
								this._direction = GridDirection.Right;
							}
							else
							{
								this._direction = GridDirection.Down;
							}
							break;
					}
				}
				//
				if (msg.Msg == WM_KEYUP)
				{
				}
				//
				if (this[this.CurrentCell] == DBNull.Value)
				{
					//
				}
				//
				return base.ProcessKeyPreview(ref msg);
			}
			catch(ObjectDisposedException)
			{
				return(true);
				/*swallow the ObjectDisposedException ocurring on a lock expiration*/
			}
		}
	}

	#endregion

}
